/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.UnicodeStreamReader;
import org.rvpf.base.xml.XMLAttribute;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.base.xml.XMLElement;

public final class JSONSupport {
    private JSONSupport() {
    }

    @Nullable
    @CheckReturnValue
    public static XMLDocument load(@Nonnull File file) {
        XMLElement rootElement;
        UnicodeStreamReader reader;
        try {
            reader = new UnicodeStreamReader(file);
        }
        catch (FileNotFoundException exception) {
            Logger.getInstance(XMLDocument.class).warn(BaseMessages.FILE_NOT_FOUND, file);
            return null;
        }
        try {
            rootElement = JSONSupport.parse(reader);
        }
        catch (XMLDocument.ParseException exception) {
            _ParseException parseException = (_ParseException)exception.getCause();
            JsonLocation location = parseException.getLocation();
            Logger.getInstance(XMLDocument.class).warn(BaseMessages.JSON_PARSE_FAILED, file, location.getLineNumber(), location.getColumnNumber(), parseException.getText());
            return null;
        }
        return new XMLDocument(rootElement);
    }

    @Nullable
    @CheckReturnValue
    public static XMLDocument load(@Nonnull URL url, @Nonnull Optional<String> encoding) {
        XMLElement rootElement;
        try {
            rootElement = JSONSupport.parse(url);
        }
        catch (XMLDocument.ParseException exception) {
            _ParseException parseException = (_ParseException)exception.getCause();
            JsonLocation location = parseException.getLocation();
            Logger.getInstance(XMLDocument.class).warn(BaseMessages.JSON_PARSE_FAILED, url, location.getLineNumber(), location.getColumnNumber(), parseException.getText());
            return null;
        }
        return new XMLDocument(rootElement);
    }

    @Nonnull
    @CheckReturnValue
    public static XMLElement parse(@Nonnull File file) throws XMLDocument.ParseException {
        try {
            return JSONSupport.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException exception) {
            throw new XMLDocument.ParseException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    public static XMLElement parse(@Nonnull InputStream inputStream) throws XMLDocument.ParseException {
        try (JsonParser parser = Json.createParser((InputStream)inputStream);){
            XMLElement xMLElement = JSONSupport._parse(parser);
            return xMLElement;
        }
    }

    @Nonnull
    @CheckReturnValue
    public static XMLElement parse(@Nonnull Reader reader) throws XMLDocument.ParseException {
        try (JsonParser parser = Json.createParser((Reader)reader);){
            XMLElement xMLElement = JSONSupport._parse(parser);
            return xMLElement;
        }
    }

    @Nonnull
    @CheckReturnValue
    public static XMLElement parse(@Nonnull String string) throws XMLDocument.ParseException {
        try (JsonParser parser = Json.createParser((Reader)new StringReader(string));){
            XMLElement xMLElement = JSONSupport._parse(parser);
            return xMLElement;
        }
    }

    @Nonnull
    @CheckReturnValue
    public static XMLElement parse(@Nonnull URL url) throws XMLDocument.ParseException {
        try {
            return JSONSupport._parse(Json.createParser((InputStream)url.openStream()));
        }
        catch (IOException exception) {
            throw new XMLDocument.ParseException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    public static String toJSON(@Nonnull XMLDocument source) {
        StringWriter stringWriter = new StringWriter();
        try {
            JSONSupport.toJSON(source, stringWriter);
        }
        catch (IOException exception) {
            throw new InternalError(exception);
        }
        return stringWriter.toString();
    }

    public static void toJSON(@Nonnull XMLDocument source, @Nonnull Writer writer) throws IOException {
        try (JsonGenerator generator = Json.createGenerator((Writer)writer);){
            XMLElement rootElement = source.getRootElement();
            generator.writeStartObject();
            generator.writeStartObject(rootElement.getName());
            JSONSupport._toJSON(rootElement, generator);
            generator.writeEnd();
            generator.writeEnd();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static XMLElement _parse(JsonParser parser) throws XMLDocument.ParseException {
        _ParserState currentState = new _ParserState(null, null, null, null);
        try {
            JsonParser.Event event;
            block14: while (true) {
                if (!parser.hasNext()) {
                    throw new _ParseException("unexpected end of input");
                }
                event = parser.next();
                switch (event) {
                    case START_OBJECT: {
                        if (currentState.isNull()) continue block14;
                        String name = currentState.getName();
                        currentState = new _ParserState(event, currentState, name, new XMLElement(name));
                        continue block14;
                    }
                    case END_ARRAY: {
                        if (currentState.getEvent() != JsonParser.Event.START_ARRAY) {
                            throw new _ParseException("unexpected end of array");
                        }
                        currentState = currentState.getParent();
                        continue block14;
                    }
                    case END_OBJECT: {
                        if (currentState.getEvent() != JsonParser.Event.START_OBJECT) {
                            throw new _ParseException("unexpected end of object");
                        }
                        XMLElement element = currentState.getElement();
                        if ((currentState = currentState.getParent()).isNull()) {
                            return element;
                        }
                        currentState.getElement().addChild(element);
                        continue block14;
                    }
                    case KEY_NAME: {
                        currentState = new _ParserState(event, currentState, parser.getString(), null);
                        continue block14;
                    }
                    case START_ARRAY: {
                        currentState = new _ParserState(event, currentState, null, null);
                        continue block14;
                    }
                    case VALUE_FALSE: {
                        currentState.getElement().setAttribute(currentState.getName(), false);
                        currentState = currentState.getParent();
                        continue block14;
                    }
                    case VALUE_NULL: {
                        throw new _ParseException("unsupported null value");
                    }
                    case VALUE_NUMBER: {
                        currentState.getElement().setAttribute(currentState.getName(), parser.getString());
                        currentState = currentState.getParent();
                        continue block14;
                    }
                    case VALUE_STRING: {
                        XMLElement element = currentState.getElement();
                        if (currentState.getName().isEmpty()) {
                            element.addText(parser.getString());
                        } else {
                            element.setAttribute(currentState.getName(), parser.getString());
                        }
                        currentState = currentState.getParent();
                        continue block14;
                    }
                    case VALUE_TRUE: {
                        currentState.getElement().setAttribute(currentState.getName(), true);
                        currentState = currentState.getParent();
                        continue block14;
                    }
                }
                break;
            }
            throw new _ParseException("unexpected event '" + event.name() + "'");
        }
        catch (_ParseException exception) {
            exception.setLocation(parser.getLocation());
            throw new XMLDocument.ParseException(exception);
        }
    }

    private static void _toJSON(XMLElement element, JsonGenerator generator) {
        for (XMLAttribute xMLAttribute : element.getAttributes()) {
            generator.write(xMLAttribute.getName(), xMLAttribute.getValue());
        }
        for (String string : element.getChildNames()) {
            List<? extends XMLElement> children = element.getChildren(string);
            if (children.size() == 1) {
                generator.writeStartObject(string);
                JSONSupport._toJSON(children.get(0), generator);
                generator.writeEnd();
                continue;
            }
            generator.writeStartArray(string);
            for (XMLElement xMLElement : children) {
                generator.writeStartObject();
                JSONSupport._toJSON(xMLElement, generator);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        String text = element.getText();
        if (!text.isEmpty()) {
            generator.write("", text);
        }
    }

    private static class _ParserState {
        private final XMLElement _element;
        private final JsonParser.Event _event;
        private final String _name;
        private final _ParserState _parent;

        _ParserState(JsonParser.Event event, _ParserState parent, String name, XMLElement element) {
            this._event = event;
            this._parent = parent;
            String string = name != null ? name : (this._name = this._parent != null ? this._parent._name : null);
            this._element = element != null ? element : (this._parent != null ? this._parent._element : null);
        }

        XMLElement getElement() throws _ParseException {
            if (this._element == null) {
                throw new _ParseException("no object");
            }
            return this._element;
        }

        JsonParser.Event getEvent() {
            return this._event;
        }

        String getName() throws _ParseException {
            if (this._name == null) {
                throw new _ParseException("no name");
            }
            return this._name;
        }

        _ParserState getParent() throws _ParseException {
            _ParserState parent = this._parent;
            if (parent == null) {
                throw new _ParseException("no parent");
            }
            if (parent.getEvent() == JsonParser.Event.KEY_NAME) {
                parent = parent.getParent();
            }
            return parent;
        }

        boolean isNull() {
            return this._parent == null;
        }
    }

    private static class _ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final AtomicReference<JsonLocation> _location = new AtomicReference();
        private final String _text;

        _ParseException(String text) {
            this._text = text;
        }

        @Override
        public String getMessage() {
            JsonLocation location = this.getLocation();
            return this._text + " at " + location.getLineNumber() + ':' + location.getColumnNumber();
        }

        JsonLocation getLocation() {
            return this._location.get();
        }

        String getText() {
            return this._text;
        }

        void setLocation(JsonLocation location) {
            this._location.set(Require.notNull(location));
        }
    }
}

