/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.tool.Require;

@Immutable
public class XMLAttribute {
    private final String _name;
    private final String _value;

    public XMLAttribute(@Nonnull String name, @Nonnull String value) {
        this._name = name.trim();
        this._value = Require.notNull(value);
    }

    public boolean equals(Object other) {
        if (other instanceof XMLAttribute) {
            XMLAttribute otherAttribute = (XMLAttribute)other;
            return this.getName().equals(otherAttribute.getName()) && this.getValue().equals(otherAttribute.getValue());
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public String getName() {
        return this._name;
    }

    @Nonnull
    @CheckReturnValue
    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getValue().hashCode();
    }

    public String toString() {
        return this._name + "='" + this._value + "'";
    }
}

