/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.UnicodeStreamReader;
import org.rvpf.base.xml.XMLElement;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

@NotThreadSafe
public final class XMLDocument
implements XMLElement.Factory {
    private static SAXParserFactory _parserFactory;
    private XMLElement.Handler _defaultHandler;
    private XMLElement.Factory _elementFactory;
    private final Map<String, XMLElement.Handler> _elementHandlers = new HashMap<String, XMLElement.Handler>();
    private PIHandler _piHandler;
    private String _publicString;
    private XMLElement _rootElement;
    private XMLElement.Handler _rootHandler;
    private String _systemString;
    private boolean _validating;
    private XMLReader _xmlReader;

    public XMLDocument() {
    }

    public XMLDocument(@Nonnull String name) {
        this.setRootElement(name);
    }

    public XMLDocument(@Nonnull XMLElement rootElement) {
        this.setRootElement(Optional.of(rootElement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @CheckReturnValue
    public static XMLDocument load(@Nonnull File file) {
        UnicodeStreamReader reader;
        try {
            reader = new UnicodeStreamReader(file);
        }
        catch (FileNotFoundException exception) {
            Logger.getInstance(XMLDocument.class).warn(BaseMessages.FILE_NOT_FOUND, file);
            return null;
        }
        XMLDocument xmlDocument = new XMLDocument();
        try {
            xmlDocument.parse(reader);
        }
        catch (ParseException exception) {
            Logger.getInstance(XMLDocument.class).warn(BaseMessages.XML_PARSE_FAILED, file, exception.getCause());
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return xmlDocument;
    }

    @Nullable
    @CheckReturnValue
    public static XMLDocument load(@Nonnull URL url, @Nonnull Optional<String> encoding) {
        XMLDocument xmlDocument = new XMLDocument();
        try {
            xmlDocument.parse(url, encoding);
        }
        catch (ParseException exception) {
            Logger.getInstance(XMLDocument.class).warn(BaseMessages.XML_PARSE_FAILED, url, exception.getCause());
            return null;
        }
        return xmlDocument;
    }

    @Nonnull
    @CheckReturnValue
    public XMLElement createXMLElement(@Nonnull String name) {
        return this.getElementFactory().newXMLElement(Require.notNull(name));
    }

    @Nonnull
    @CheckReturnValue
    public XMLElement.Factory getElementFactory() {
        return this._elementFactory != null ? this._elementFactory : this;
    }

    @Nonnull
    @CheckReturnValue
    public XMLElement getRootElement() {
        return this._rootElement;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public XMLElement newXMLElement(@Nonnull String name) {
        return new XMLElement(name);
    }

    @Nonnull
    public XMLElement parse(@Nonnull Reader reader) throws ParseException {
        return this._parse(new InputSource(reader));
    }

    @Nonnull
    public XMLElement parse(@Nonnull String string) throws ParseException {
        return this.parse(new StringReader(string));
    }

    @Nonnull
    public XMLElement parse(@Nonnull File file, @Nonnull Optional<String> encoding) throws ParseException {
        return this._parse(file.toURI().toString(), encoding);
    }

    @Nonnull
    public XMLElement parse(@Nonnull InputStream inputStream, @Nonnull Optional<String> encoding) throws ParseException {
        InputSource inputSource = new InputSource(inputStream);
        if (encoding.isPresent()) {
            inputSource.setEncoding(encoding.get());
        }
        return this._parse(inputSource);
    }

    @Nonnull
    public XMLElement parse(@Nonnull URL url, @Nonnull Optional<String> encoding) throws ParseException {
        return this._parse(url.toString(), encoding);
    }

    public void setDefaultHandler(@Nonnull Optional<XMLElement.Handler> handler) {
        this._defaultHandler = handler.orElse(null);
    }

    public void setDocTypeStrings(@Nonnull String[] strings) {
        this.setDocTypeStrings(Optional.ofNullable(strings[0]), Optional.ofNullable(strings[1]));
    }

    public void setDocTypeStrings(@Nonnull Optional<String> publicString, @Nonnull Optional<String> systemString) {
        this._publicString = publicString.orElse(null);
        this._systemString = systemString.orElse(null);
    }

    public void setElementFactory(@Nonnull XMLElement.Factory elementFactory) {
        this._elementFactory = Require.notNull(elementFactory);
    }

    public void setElementHandler(@Nonnull String elementPath, @Nonnull Optional<XMLElement.Handler> handler) {
        if (handler.isPresent()) {
            this._elementHandlers.put(elementPath, handler.get());
        } else {
            this._elementHandlers.remove(elementPath);
        }
    }

    public void setPIHandler(@Nonnull Optional<PIHandler> piHandler) {
        this._piHandler = piHandler.orElse(null);
    }

    public void setRootElement(@Nonnull Optional<XMLElement> rootElement) {
        this._rootElement = rootElement.orElse(null);
    }

    public void setRootElement(@Nonnull String name) {
        this.setRootElement(Optional.of(this.createXMLElement(name)));
    }

    public void setRootHandler(@Nonnull Optional<XMLElement.Handler> handler) {
        this._rootHandler = handler.orElse(null);
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public void setXMLReader(@Nonnull Optional<XMLReader> xmlReader) {
        this._xmlReader = xmlReader.orElse(null);
    }

    public String toString() {
        return this.toXML(Optional.empty(), true);
    }

    @Nonnull
    @CheckReturnValue
    public String toXML(@Nonnull Optional<String> encoding, boolean indented) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.toXML(encoding, indented, stringBuilder);
        }
        catch (IOException exception) {
            throw new InternalError(exception);
        }
        return stringBuilder.toString();
    }

    public void toXML(@Nonnull Optional<String> encoding, boolean indented, @Nonnull Appendable destination) throws IOException {
        String trimmedEncoding;
        destination.append("<?xml version='1.0'");
        if (encoding.isPresent() && (trimmedEncoding = encoding.get().trim()).length() > 0) {
            destination.append(" encoding='");
            destination.append(trimmedEncoding);
            destination.append("'");
        }
        destination.append("?>\n");
        if (this._rootElement != null) {
            destination.append("<!DOCTYPE ");
            destination.append(this._rootElement.getName());
            if (this._publicString != null) {
                destination.append(" PUBLIC \"");
                destination.append(this._publicString);
                if (this._systemString != null) {
                    destination.append("\" '");
                    destination.append(this._systemString);
                    destination.append("'");
                } else {
                    destination.append("\"");
                }
            } else if (this._systemString != null) {
                destination.append(" SYSTEM '");
                destination.append(this._systemString);
                destination.append("'");
            }
            destination.append(">\n");
            this._rootElement.toXML(indented ? 0 : -1, destination);
        }
    }

    @Nonnull
    @CheckReturnValue
    XMLElement.Handler _getElementHandler(@Nonnull String elementPath) {
        XMLElement.Handler handler = this._elementHandlers.get(elementPath);
        return handler != null ? handler : this._defaultHandler;
    }

    @Nonnull
    @CheckReturnValue
    Optional<PIHandler> _getPIHandler() {
        return Optional.ofNullable(this._piHandler);
    }

    @Nonnull
    @CheckReturnValue
    Optional<XMLElement.Handler> _getRootHandler() {
        return Optional.ofNullable(this._rootHandler);
    }

    private XMLElement _parse(InputSource inputSource) throws ParseException {
        if (this._xmlReader == null) {
            if (_parserFactory == null) {
                _parserFactory = SAXParserFactory.newInstance();
            }
            _parserFactory.setNamespaceAware(true);
            _parserFactory.setValidating(this._validating);
            try {
                this._xmlReader = _parserFactory.newSAXParser().getXMLReader();
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this._rootElement = this.createXMLElement("");
        _XMLHandler xmlHandler = new _XMLHandler();
        this._xmlReader.setEntityResolver((EntityResolver)new CatalogResolver());
        this._xmlReader.setContentHandler(xmlHandler);
        this._xmlReader.setErrorHandler(xmlHandler);
        try {
            this._xmlReader.parse(inputSource);
        }
        catch (IOException exception) {
            throw new ParseException(exception);
        }
        catch (SAXException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof ParseException) {
                throw (ParseException)cause;
            }
            if (cause != null) {
                throw new ParseException(cause);
            }
            throw new ParseException(exception);
        }
        return this._rootElement;
    }

    private XMLElement _parse(String systemId, Optional<String> encoding) throws ParseException {
        InputSource inputSource = new InputSource(systemId);
        if (encoding.isPresent()) {
            inputSource.setEncoding(encoding.get());
        }
        return this._parse(inputSource);
    }

    private final class _XMLHandler
    extends DefaultHandler2 {
        private XMLElement _element;
        private final LinkedList<XMLElement> _parents = new LinkedList();

        _XMLHandler() {
            this._element = XMLDocument.this.getRootElement();
            if (this._element.isNameEmpty()) {
                this._element.clearName();
            }
        }

        @Override
        public void characters(char[] buffer, int start, int length) throws SAXException {
            if (this._element != null) {
                this._element.addText(new String(buffer, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            try {
                Optional<XMLElement.Handler> rootHandler;
                XMLElement.Handler elementHandler;
                if (this._element != null && (elementHandler = XMLDocument.this._getElementHandler(this._element.getPath())) != null) {
                    this._element = elementHandler.onElementEnd(this._element);
                }
                if (this._element != null && this._parents.isEmpty() && (rootHandler = XMLDocument.this._getRootHandler()).isPresent()) {
                    this._element = rootHandler.get().onElementEnd(this._element);
                }
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
            if (this._parents.isEmpty()) {
                XMLDocument.this.setRootElement(Optional.ofNullable(this._element));
            } else {
                XMLElement parent = this._parents.removeLast();
                if (this._element != null) {
                    parent.addChild(this._element);
                }
                this._element = parent;
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            Optional<PIHandler> piHandler = XMLDocument.this._getPIHandler();
            if (piHandler.isPresent()) {
                try {
                    piHandler.get().onPI(target, data != null ? data : "");
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
            return new InputSource(new StringReader(""));
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String elementName;
            String string = elementName = localName.length() > 0 ? localName : name;
            if (this._element != null && this._element.isNameNull()) {
                this._element.setName(elementName);
            } else {
                this._parents.addLast(this._element);
                if (this._element != null) {
                    String prefix = this._element.getPath();
                    this._element = XMLDocument.this.createXMLElement(elementName);
                    this._element.setPath(prefix);
                }
            }
            if (this._element != null) {
                int attributesLength = attributes.getLength();
                for (int i = 0; i < attributesLength; ++i) {
                    String attributeName = attributes.getLocalName(i);
                    if (attributeName.isEmpty()) {
                        attributeName = attributes.getQName(i);
                    }
                    this._element.setAttribute(attributeName, attributes.getValue(i));
                }
                try {
                    XMLElement.Handler elementHandler;
                    Optional<XMLElement.Handler> rootHandler;
                    if (this._parents.isEmpty() && (rootHandler = XMLDocument.this._getRootHandler()).isPresent()) {
                        this._element = rootHandler.get().onElementStart(this._element);
                    }
                    if (this._element != null && (elementHandler = XMLDocument.this._getElementHandler(this._element.getPath())) != null) {
                        this._element = elementHandler.onElementStart(this._element);
                    }
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    public static final class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(@Nonnull Throwable cause) {
            super(cause);
        }

        @Override
        @Nonnull
        public Throwable getCause() {
            return Require.notNull(super.getCause());
        }
    }

    public static final class ElementReader
    extends InputStreamReader
    implements XMLElement.Handler {
        private boolean _elementEnded;
        private boolean _inputEnded;

        public ElementReader(@Nonnull InputStream input) {
            super(input, StandardCharsets.UTF_8);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean markSupported() {
            return !this._inputEnded;
        }

        @Override
        public XMLElement onElementEnd(@Nonnull XMLElement element) {
            this._elementEnded = true;
            return element;
        }

        @Override
        public XMLElement onElementStart(@Nonnull XMLElement element) {
            return element;
        }

        @Override
        public int read() throws IOException {
            char[] buffer = new char[1];
            int read = this.read(buffer, 0, buffer.length);
            return read > 0 ? buffer[0] : read;
        }

        @Override
        public int read(char[] buffer, int offset, int length) {
            int read;
            if (this._elementEnded || this._inputEnded) {
                read = -1;
            } else {
                try {
                    read = super.read(buffer, offset, length);
                }
                catch (IOException exception) {
                    read = -1;
                }
                if (read <= 0) {
                    this._inputEnded = true;
                }
            }
            return read;
        }

        @Override
        public boolean ready() throws IOException {
            return !this._elementEnded && super.ready();
        }

        @Override
        public void reset() {
            this._elementEnded = false;
        }
    }

    public static interface PIHandler {
        public void onPI(@Nonnull String var1, @Nonnull String var2) throws PIException;

        public static final class PIException
        extends Exception {
            private static final long serialVersionUID = 1L;
        }
    }
}

