/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;
import org.rvpf.base.xml.XMLAttribute;
import org.rvpf.base.xml.XMLDocument;

@NotThreadSafe
public class XMLElement {
    private static final Factory _DEFAULT_FACTORY = new Factory(){

        @Override
        public XMLElement newXMLElement(String name) {
            return new XMLElement(name);
        }
    };
    private static final String _FALSE = "0";
    private static final String _INDENT = "    ";
    private static final String _TRUE = "1";
    private List<XMLAttribute> _attributeList;
    private Map<String, String> _attributeMap;
    private List<XMLElement> _children;
    private String _name;
    private XMLElement _parent;
    private String _path;
    private StringBuilder _text;

    public XMLElement(@Nonnull String name) {
        this.setName(name);
    }

    public XMLElement(@Nonnull String name, Object ... contents) {
        this(name);
        for (Object content : contents) {
            if (content instanceof XMLElement) {
                this.addChild((XMLElement)content);
                continue;
            }
            if (content instanceof XMLAttribute) {
                this.setAttribute((XMLAttribute)content);
                continue;
            }
            if (content == null) continue;
            this.addText(content.toString());
        }
    }

    private XMLElement(XMLElement other) {
        this._name = other._name;
        this._parent = other._parent;
        this._path = other._path;
        if (other._attributeMap != null) {
            this._attributeMap = new LinkedHashMap<String, String>(other._attributeMap);
        }
        if (other._children != null) {
            this._children = new ArrayList<XMLElement>(other._children);
        }
        if (other._text != null) {
            this._text = new StringBuilder(other._text.toString());
        }
    }

    @Nonnull
    @CheckReturnValue
    public static String escape(@Nonnull CharSequence text, char quote) {
        StringBuilder stringBuilder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            String entity;
            char next = text.charAt(i);
            switch (next) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\"': {
                    entity = quote == next ? "&quot;" : null;
                    break;
                }
                case '\'': {
                    entity = quote == next ? "&apos;" : null;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    entity = null;
                    break;
                }
                default: {
                    String string = entity = next < ' ' ? "&#" + next + ";" : null;
                }
            }
            if (entity != null) {
                stringBuilder.append(entity);
                continue;
            }
            stringBuilder.append(next);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public XMLElement addChild(@Nonnull String name) {
        XMLElement child = this.getFactory().newXMLElement(name);
        this.addChild(child);
        return child;
    }

    public void addChild(@Nonnull XMLElement child) {
        child._parent = this;
        if (this._children == null) {
            this._children = new ArrayList<XMLElement>(4);
        }
        this._children.add(child);
        child.setPath(this._path);
    }

    public final void addText(@Nonnull String text) {
        if (this._text == null) {
            if (text.trim().isEmpty()) {
                return;
            }
            this._text = new StringBuilder();
        }
        this._text.append(text);
    }

    @CheckReturnValue
    public boolean containsAttribute(@Nonnull String name) {
        return this._attributeMap != null ? this._attributeMap.containsKey(name) : false;
    }

    @Nonnull
    @CheckReturnValue
    public XMLElement copy() {
        return new XMLElement(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        XMLElement otherElement = (XMLElement)other;
        if (!this._name.equals(otherElement._name)) {
            return false;
        }
        if (this._text != null ? !this._text.equals(otherElement._text) : otherElement._text != null) {
            return false;
        }
        if (this._attributeMap != null) {
            if (this._attributeMap.size() != otherElement._attributeMap.size()) {
                for (Map.Entry<String, String> entry : this._attributeMap.entrySet()) {
                    if (entry.getValue().equals(otherElement._attributeMap.get(entry.getKey()))) continue;
                    return false;
                }
            }
        } else if (otherElement._attributeMap != null) {
            return false;
        }
        return !(this._children != null ? !this._children.equals(otherElement._children) : otherElement._children != null);
    }

    @CheckReturnValue
    public final int getAttributeCount() {
        return this._attributeMap != null ? this._attributeMap.size() : 0;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getAttributeValue(@Nonnull String name, @Nonnull Optional<String> defaultValue) {
        String value = this._attributeMap != null ? this._attributeMap.get(Require.notNull(name)) : null;
        return value != null ? Optional.of(value) : defaultValue;
    }

    @Nonnull
    @CheckReturnValue
    public final List<XMLAttribute> getAttributes() {
        if (this._attributeList == null) {
            if (this._attributeMap != null) {
                this._attributeList = new ArrayList<XMLAttribute>(this._attributeMap.size());
                this._attributeMap.forEach((key, value) -> this._attributeList.add(new XMLAttribute((String)key, (String)value)));
            } else {
                this._attributeList = new ArrayList<XMLAttribute>(0);
            }
        }
        return this._attributeList;
    }

    @Nonnull
    @CheckReturnValue
    public XMLElement getChild(int index) {
        if (this._children == null) {
            throw new IndexOutOfBoundsException();
        }
        return this._children.get(index);
    }

    @CheckReturnValue
    public final int getChildCount() {
        return this._children != null ? this._children.size() : 0;
    }

    @Nonnull
    @CheckReturnValue
    public Set<? extends String> getChildNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (this._children != null) {
            for (XMLElement child : this._children) {
                names.add(child.getName());
            }
        }
        return names;
    }

    @Nonnull
    @CheckReturnValue
    public List<? extends XMLElement> getChildren() {
        if (this._children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._children);
    }

    @Nonnull
    @CheckReturnValue
    public List<? extends XMLElement> getChildren(@Nonnull String name) {
        LinkedList<XMLElement> children = new LinkedList<XMLElement>();
        if (this._children != null) {
            for (XMLElement child : this._children) {
                if (!child.getName().equals(name)) continue;
                children.add(child);
            }
        }
        return children;
    }

    @Nonnull
    @CheckReturnValue
    public Factory getFactory() {
        return _DEFAULT_FACTORY;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<XMLElement> getFirstChild(@Nonnull String name) {
        if (this._children != null) {
            for (XMLElement child : this._children) {
                if (!child.getName().equals(name)) continue;
                return Optional.of(child);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final String getName() {
        Require.failure(this._name.isEmpty());
        return this._name;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<? extends XMLElement> getParent() {
        return Optional.ofNullable(this._parent);
    }

    @Nonnull
    @CheckReturnValue
    public final String getPath() {
        Require.failure(this._name.isEmpty());
        return this._path;
    }

    @Nonnull
    @CheckReturnValue
    public String getText() {
        return this._text != null ? this._text.toString().trim() : "";
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public final boolean isNameEmpty() {
        return this._name != null && this._name.isEmpty();
    }

    public final void removeAttribute(@Nonnull String attributeName) {
        if (this._attributeMap != null) {
            this._attributeMap.remove(attributeName);
        }
    }

    public final void setAttribute(@Nonnull XMLAttribute attribute) {
        this.setAttribute(attribute.getName(), attribute.getValue());
    }

    public final void setAttribute(@Nonnull String attributeName, boolean attributeValue) {
        this.setAttribute(attributeName, attributeValue ? _TRUE : _FALSE);
    }

    public final void setAttribute(@Nonnull String attributeName, @Nonnull Optional<String> attributeValue) {
        if (attributeValue.isPresent()) {
            this.setAttribute(attributeName, attributeValue.get());
        } else if (this._attributeMap != null) {
            this.removeAttribute(attributeName);
        }
    }

    public final void setAttribute(@Nonnull String attributeName, @Nonnull String attributeValue) {
        this._attributeList = null;
        if (this._attributeMap == null) {
            this._attributeMap = new LinkedHashMap<String, String>();
        }
        this._attributeMap.put(Require.notNull(attributeName), Require.notNull(attributeValue));
    }

    public final void setName(@Nonnull String elementName) {
        Require.success(this._name == null || this._name.isEmpty());
        this._name = elementName.trim();
        this._path = '/' + this._name;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.toXML(0, stringBuilder);
        }
        catch (IOException exception) {
            throw new InternalError(exception);
        }
        return stringBuilder.toString();
    }

    protected final void disownChildren() {
        if (this._children != null) {
            this._children.clear();
        }
    }

    final void clearName() {
        this._name = null;
        this._path = null;
    }

    @CheckReturnValue
    final boolean isNameNull() {
        return this._name == null;
    }

    void setPath(@Nonnull String prefix) {
        this._path = prefix + '/' + this._name;
        if (this._children != null) {
            for (XMLElement element : this._children) {
                element.setPath(this._path);
            }
        }
    }

    final void toXML(int level, @Nonnull Appendable destination) throws IOException {
        int i;
        for (i = 0; i < level; ++i) {
            destination.append(_INDENT);
        }
        destination.append('<');
        destination.append(this.getName());
        if (this._attributeMap != null) {
            for (Map.Entry<String, String> entry : this._attributeMap.entrySet()) {
                destination.append(' ');
                destination.append(entry.getKey());
                destination.append("='");
                destination.append(XMLElement.escape(entry.getValue(), '\''));
                destination.append("'");
            }
        }
        if (this._children != null || this._text != null) {
            if (this._children != null) {
                destination.append(">\n");
                for (XMLElement element : this._children) {
                    element.toXML(level < 0 ? level : level + 1, destination);
                }
                for (i = 0; i < level; ++i) {
                    destination.append(_INDENT);
                }
            } else {
                destination.append('>');
            }
            if (this._text != null) {
                if (this._children != null) {
                    destination.append(_INDENT);
                }
                destination.append(XMLElement.escape(this._text.toString().trim(), '\u0000'));
                if (this._children != null) {
                    destination.append('\n');
                    for (i = 0; i < level; ++i) {
                        destination.append(_INDENT);
                    }
                }
            }
            destination.append("</");
            destination.append(this.getName());
            destination.append(">\n");
        } else {
            destination.append("/>\n");
        }
    }

    public static interface Handler {
        @CheckForNull
        public XMLElement onElementEnd(@Nonnull XMLElement var1) throws XMLDocument.ParseException;

        @CheckForNull
        public XMLElement onElementStart(@Nonnull XMLElement var1) throws XMLDocument.ParseException;
    }

    public static interface Factory {
        @Nonnull
        @CheckReturnValue
        public XMLElement newXMLElement(@Nonnull String var1);
    }
}

