/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.Writer;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.PointValuesDumper;
import org.rvpf.base.value.VersionedValue;
import org.rvpf.base.xml.streamer.Streamer;

@NotThreadSafe
public final class PointValuesDumperOutput
implements PointValuesDumper.Output {
    private Optional<DateTime> _firstVersion = Optional.empty();
    private Optional<DateTime> _lastVersion = Optional.empty();
    private final Streamer.Output _output;
    private final Streamer _streamer = Streamer.newInstance();

    public PointValuesDumperOutput(@Nonnull Writer writer) {
        if (!this._streamer.setUp(Optional.empty(), Optional.empty())) {
            throw new RuntimeException();
        }
        this._output = this._streamer.newOutput(writer);
    }

    public void close() {
        this._output.close();
        this._streamer.tearDown();
    }

    @Override
    public void flush() {
        this._output.flush();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getFirstVersion() {
        return this._firstVersion;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getLastVersion() {
        return this._lastVersion;
    }

    @Override
    public void output(VersionedValue versionedValue) throws Exception {
        if (!this._output.add(Require.notNull(versionedValue))) {
            throw new InternalError();
        }
        if (!this._firstVersion.isPresent()) {
            this._firstVersion = Optional.of(versionedValue.getVersion());
        }
        this._lastVersion = Optional.of(versionedValue.getVersion());
    }
}

