/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.NoCloseReader;
import org.rvpf.base.util.PointValuesLoader;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.VersionedValue;
import org.rvpf.base.xml.streamer.Streamer;

@NotThreadSafe
public final class PointValuesLoaderInput
implements PointValuesLoader.Input {
    private Optional<DateTime> _firstVersion = Optional.empty();
    private final Streamer.Input _input;
    private Optional<DateTime> _lastVersion = Optional.empty();
    private final Streamer _streamer = Streamer.newInstance();

    public PointValuesLoaderInput(@Nonnull Reader reader) {
        if (!this._streamer.setUp(Optional.empty(), Optional.empty())) {
            throw new RuntimeException();
        }
        this._input = this._streamer.newInput(new NoCloseReader(Require.notNull(reader)));
    }

    public void close() {
        this._input.close();
        this._streamer.tearDown();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getFirstVersion() {
        return this._firstVersion;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getLastVersion() {
        return this._lastVersion;
    }

    @Override
    public Optional<PointValue> input() throws Exception {
        Optional<DateTime> version;
        Optional<Object> pointValue;
        try {
            pointValue = Optional.of((PointValue)this._input.next());
        }
        catch (NoSuchElementException exception) {
            pointValue = Optional.empty();
        }
        if (pointValue.isPresent() && pointValue.get() instanceof VersionedValue && (version = Optional.ofNullable(((VersionedValue)pointValue.get()).getVersion())).isPresent()) {
            if (!this._firstVersion.isPresent()) {
                this._firstVersion = version;
            }
            this._lastVersion = version;
        }
        return pointValue;
    }
}

