/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.xml.streamer.StreamedMessagesWriter;

@NotThreadSafe
public final class StreamedMessagesClient
extends StreamedMessagesWriter {
    public static final String DATA_SUFFIX_PROPERTY = "suffix.data";
    public static final String DEFAULT_DATA_SUFFIX = ".data";
    public static final String DEFAULT_TRANS_SUFFIX = ".trans";
    public static final String PREFIX_PROPERTY = "name.prefix";
    public static final String TRANS_SUFFIX_PROPERTY = "suffix.trans";
    private String _dataSuffix;
    private File _directory;
    private DateTime _nameStamp = DateTime.fromRaw(0L);
    private String _nameSuffix = "";
    private String _prefix;
    private File _transFile;
    private String _transSuffix;
    private String _transaction;

    @Override
    public synchronized boolean add(Serializable message) {
        if (this._transaction == null) {
            DateTime nameStamp = DateTime.now();
            if (nameStamp.isNotAfter(this._nameStamp)) {
                nameStamp = this._nameStamp.after();
            }
            this._nameStamp = nameStamp;
            String transaction = this._prefix + this._nameStamp.toFileName() + this._nameSuffix;
            File file = new File(this._directory, transaction + this._transSuffix);
            try {
                super.open(file, Optional.empty());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            this._transFile = file;
            this._transaction = transaction;
        }
        return super.add(message);
    }

    @Override
    public void close() {
    }

    public synchronized void commit() {
        if (this._transaction != null) {
            super.close();
            try {
                File dataFile = new File(this._directory, this._transaction + this._dataSuffix);
                if (!this._transFile.renameTo(dataFile)) {
                    throw new RuntimeException(Message.format(BaseMessages.FILE_RENAME_FAILED, this._transFile, dataFile));
                }
            }
            finally {
                this._transFile = null;
                this._transaction = null;
            }
        }
    }

    @Override
    public synchronized void flush() {
        if (this._transaction != null) {
            super.flush();
        }
    }

    @Nonnull
    @CheckReturnValue
    public synchronized DateTime getNameStamp() {
        return this._nameStamp;
    }

    @Override
    public void open(File file, Optional<Charset> charset) {
        throw new UnsupportedOperationException();
    }

    public synchronized void rollback() {
        if (this._transaction != null) {
            super.close();
            try {
                if (!this._transFile.delete()) {
                    throw new RuntimeException(Message.format(BaseMessages.FILE_DELETE_FAILED, this._transFile));
                }
            }
            finally {
                this._transFile = null;
                this._transaction = null;
            }
        }
    }

    public void setNameSuffix(@Nonnull Optional<String> nameSuffix) throws Require.FailureException {
        Require.equal(null, this._transaction, (Object)BaseMessages.FILE_ALREADY_CREATED);
        this._nameSuffix = nameSuffix.orElse("");
    }

    @CheckReturnValue
    public synchronized boolean setUp(@Nonnull File directory, @Nonnull KeyedGroups configProperties, @Nonnull KeyedValues moduleProperties) {
        if (!this.setUp((Optional)Optional.of(configProperties), (Optional)Optional.of(moduleProperties))) {
            return false;
        }
        return this._setUp(directory, configProperties);
    }

    @Override
    public synchronized void tearDown() {
        if (this._directory != null) {
            this.rollback();
            this._directory = null;
        }
        super.tearDown();
    }

    private synchronized boolean _setUp(File directory, KeyedGroups configProperties) {
        File[] files;
        this._prefix = configProperties.getString(PREFIX_PROPERTY, Optional.of("")).get();
        this._transSuffix = configProperties.getString(TRANS_SUFFIX_PROPERTY, Optional.of(DEFAULT_TRANS_SUFFIX)).get();
        this._dataSuffix = configProperties.getString(DATA_SUFFIX_PROPERTY, Optional.of(DEFAULT_DATA_SUFFIX)).get();
        for (File file : files = Require.notNull(directory.listFiles())) {
            DateTime nameStamp;
            if (!file.isFile()) continue;
            String name = file.getName();
            int dotIndex = name.indexOf(46);
            if (dotIndex >= 0) {
                name = name.substring(0, dotIndex);
            }
            if (name.length() < 23 || (name = name.substring(name.length() - 23)).isEmpty()) continue;
            try {
                nameStamp = DateTime.fromString(name);
            }
            catch (IllegalArgumentException exception) {
                continue;
            }
            Require.notNull(nameStamp);
            if (!nameStamp.isAfter(this._nameStamp)) continue;
            this._nameStamp = nameStamp;
        }
        this._directory = directory;
        return true;
    }
}

