/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.util.NoCloseReader;
import org.rvpf.base.xml.streamer.StreamedMessagesAccess;
import org.rvpf.base.xml.streamer.Streamer;

@NotThreadSafe
public final class StreamedMessagesConverter
extends StreamedMessagesAccess {
    private Streamer.Input _input;
    private Streamer.Output _output;
    private final _XMLReader _reader = new _XMLReader();
    private final _XMLWriter _writer = new _XMLWriter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public Optional<Serializable> fromXMLChars(@Nonnull char[] xml) {
        _XMLReader _XMLReader2 = this._reader;
        synchronized (_XMLReader2) {
            if (this._input == null) {
                this._input = this.getStreamer().newInput(new NoCloseReader(this._reader));
            }
            this._reader.reset(xml);
            Serializable message = this._input.next();
            if (message == null) {
                this._input.close();
                this._input = null;
            }
            return Optional.ofNullable(message);
        }
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Serializable> fromXMLString(@Nonnull String xml) {
        if (xml.trim().isEmpty()) {
            return Optional.empty();
        }
        return this.fromXMLChars(xml.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        Closeable closeable = this._reader;
        synchronized (closeable) {
            if (this._input != null) {
                this._input.close();
                this._input = null;
            }
        }
        closeable = this._writer;
        synchronized (closeable) {
            if (this._output != null) {
                this._output.close();
                this._output = null;
            }
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @CheckReturnValue
    public char[] toXMLChars(@Nonnull Serializable message) {
        _XMLWriter _XMLWriter2 = this._writer;
        synchronized (_XMLWriter2) {
            if (this._output == null) {
                this._output = this.getStreamer().newOutput(this._writer);
            }
            this._writer.reset();
            if (!this._output.add(message)) {
                return null;
            }
            this._output.flush();
            return this._writer.toCharArray();
        }
    }

    @Nullable
    @CheckReturnValue
    public String toXMLString(@Nonnull Serializable message) {
        char[] chars = this.toXMLChars(message);
        return chars != null ? new String(chars) : null;
    }

    private static final class _XMLWriter
    extends CharArrayWriter {
        _XMLWriter() {
        }
    }

    private static final class _XMLReader
    extends CharArrayReader {
        private static final char[] _EMPTY_CHAR_ARRAY = new char[0];

        _XMLReader() {
            super(_EMPTY_CHAR_ARRAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset(@Nonnull char[] xml) {
            Object object = this.getLock();
            synchronized (object) {
                this.setBuffer(xml);
            }
        }

        @Nonnull
        @CheckReturnValue
        private Object getLock() {
            return this.lock;
        }

        private void setBuffer(@Nonnull char[] xml) {
            this.markedPos = 0;
            this.pos = 0;
            this.buf = xml;
            this.count = xml.length;
        }
    }
}

