/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.base.xml.streamer.StreamedMessagesAccess;
import org.rvpf.base.xml.streamer.Streamer;

@NotThreadSafe
public class StreamedMessagesPortClient
extends StreamedMessagesAccess {
    public static final String CLIENT_ATTRIBUTE = "client";
    public static final String DONE_ELEMENT = "done";
    public static final String EXCEPTION_ATTRIBUTE = "exception";
    public static final String FAILED_ELEMENT = "failed";
    public static final String FLUSH_ATTRIBUTE = "flush";
    public static final String FLUSH_ELEMENT = "flush";
    public static final String ID_ATTRIBUTE = "id";
    public static final String LOGIN_ELEMENT = "login";
    public static final String MESSAGES_ELEMENT = "messages";
    public static final String PASSWORD_ATTRIBUTE = "password";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String USER_ATTRIBUTE = "user";
    private final String _client;
    private final XMLDocument _document = new XMLDocument();
    private long _id;
    private InputStream _input;
    private final List<Serializable> _messages = new LinkedList<Serializable>();
    private OutputStream _output;
    private int _pending;
    private Reader _reader;
    private Socket _socket;

    public StreamedMessagesPortClient(@Nonnull String client) {
        this._client = client.trim();
    }

    public void addMessage(@Nonnull Serializable message) {
        this._messages.add(Require.notNull(message));
        ++this._pending;
    }

    public void close() {
        if (this.isOpen()) {
            try {
                this.flush();
                if (this._output != null) {
                    this._output.close();
                }
                if (this._input != null) {
                    this._input.close();
                }
            }
            catch (ServiceNotAvailableException serviceNotAvailableException) {
            }
            catch (SocketException socketException) {
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            finally {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {}
            }
            this._socket = null;
            this._output = null;
            this._input = null;
            this._messages.clear();
            this._pending = 0;
            this._id = 0L;
        }
    }

    public void flush() throws ServiceNotAvailableException {
        if (this._pending > 0) {
            if (this._messages.isEmpty()) {
                this._sendXML(new XMLElement("flush"));
            } else {
                this.sendMessages(true);
            }
            this._pending = 0;
        }
    }

    @CheckReturnValue
    public boolean isOpen() {
        return this._socket != null;
    }

    public void login(@Nonnull LoginInfo loginInfo) throws ServiceNotAvailableException {
        Require.equal(0L, this._pending, (Object)BaseMessages.PENDING_MESSAGES);
        if (!loginInfo.getUser().isPresent()) {
            return;
        }
        XMLElement loginElement = new XMLElement(LOGIN_ELEMENT);
        char[] password = loginInfo.getPassword().get();
        loginElement.setAttribute(CLIENT_ATTRIBUTE, XMLElement.escape(this._client, '\''));
        loginElement.setAttribute(USER_ATTRIBUTE, XMLElement.escape(loginInfo.getUser().get(), '\''));
        loginElement.setAttribute(PASSWORD_ATTRIBUTE, XMLElement.escape(new String(password), '\''));
        this._sendXML(loginElement);
    }

    public void login(@Nonnull Optional<String> user, @Nonnull Optional<char[]> password) throws ServiceNotAvailableException {
        this.login(new LoginInfo(user, password));
    }

    public void open(@Nonnull String addressString, @Nonnull Optional<SecurityContext> securityContext) throws ServiceNotAvailableException {
        Optional<InetSocketAddress> socketAddress = Inet.socketAddress(addressString);
        if (!socketAddress.isPresent()) {
            throw new IllegalArgumentException(Message.format(BaseMessages.BAD_ADDRESS, addressString));
        }
        boolean secure = securityContext.isPresent() && (securityContext.get().isCertified() || securityContext.get().isSecure() || !Inet.isOnLocalHost(socketAddress.get().getAddress()));
        try {
            if (secure) {
                securityContext.get().checkForSecureOperation();
                SSLContext sslContext = securityContext.get().createSSLContext();
                this._socket = sslContext.getSocketFactory().createSocket();
                this._socket.connect(socketAddress.get());
                ((SSLSocket)this._socket).startHandshake();
            } else {
                this._socket = SocketFactory.getDefault().createSocket();
                this._socket.connect(socketAddress.get());
            }
            this._output = new BufferedOutputStream(this._socket.getOutputStream());
            this._input = new BufferedInputStream(this._socket.getInputStream());
            XMLDocument.ElementReader reader = new XMLDocument.ElementReader(this._input);
            this._document.setRootHandler(Optional.of(reader));
            this._reader = reader;
        }
        catch (SocketException exception) {
            throw new ServiceNotAvailableException(exception);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void sendMessages(boolean flush) throws ServiceNotAvailableException {
        if (!this._messages.isEmpty()) {
            XMLElement messagesElement = new XMLElement(MESSAGES_ELEMENT);
            Streamer.Output output = this.getStreamer().newOutput(messagesElement);
            for (Serializable message : this._messages) {
                if (output.add(message)) continue;
                Logger.getInstance(this.getClass()).warn(BaseMessages.BAD_MESSAGE, message);
            }
            output.close();
            this._messages.clear();
            if (flush) {
                messagesElement.setAttribute("flush", String.valueOf(flush));
            }
            this._sendXML(messagesElement);
        }
    }

    private void _sendXML(XMLElement element) throws ServiceNotAvailableException {
        element.setAttribute(ID_ATTRIBUTE, String.valueOf(++this._id));
        byte[] bytes = element.toString().getBytes(StandardCharsets.UTF_8);
        try {
            this._output.write(bytes);
            this._output.flush();
            XMLElement response = this._document.parse(this._reader);
            String ref = response.getAttributeValue(REF_ATTRIBUTE, Optional.of("0")).orElse(null);
            if (Long.parseLong(ref) != this._id) {
                throw new IOException(Message.format(BaseMessages.MISMATCHED_REF, String.valueOf(this._id), ref));
            }
            if (!DONE_ELEMENT.equals(response.getName())) {
                if (FAILED_ELEMENT.equals(response.getName())) {
                    throw new IOException(Message.format(BaseMessages.FAILED, response.getAttributeValue(EXCEPTION_ATTRIBUTE, Optional.empty()).orElse(null), response.getText()));
                }
                throw new IOException(Message.format(BaseMessages.UNEXPECTED_RESPONSE, response));
            }
            this._reader.reset();
        }
        catch (SocketException exception) {
            throw new ServiceNotAvailableException(exception);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (XMLDocument.ParseException exception) {
            throw new ServiceNotAvailableException(exception);
        }
    }
}

