/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.util.NoCloseReader;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.base.xml.streamer.StreamedMessagesAccess;
import org.rvpf.base.xml.streamer.Streamer;

@NotThreadSafe
public class StreamedMessagesReader
extends StreamedMessagesAccess
implements Iterator<Serializable>,
Iterable<Serializable> {
    private Streamer.Input _input;

    public void close() {
        if (this._input != null) {
            this._input.close();
            this._input = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this._input.hasNext();
    }

    @Override
    public Iterator<Serializable> iterator() {
        return this._input.iterator();
    }

    @Override
    public Serializable next() {
        return this._input.next();
    }

    public void open(@Nonnull Reader reader) {
        this._input = this.getStreamer().newInput(new NoCloseReader(reader));
    }

    public void open(@Nonnull XMLElement parentElement) {
        this._input = this.getStreamer().newInput(parentElement);
    }

    public void open(@Nonnull File file, @Nonnull Optional<Charset> charset) throws FileNotFoundException {
        this._input = this.getStreamer().newInput(file, charset);
    }

    public void open(@Nonnull InputStream inputStream, @Nonnull Optional<Charset> charset) {
        this._input = this.getStreamer().newInput(inputStream, charset);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void tearDown() {
        this.close();
        super.tearDown();
    }
}

