/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.base.xml.streamer.StreamedMessagesAccess;
import org.rvpf.base.xml.streamer.Streamer;

@NotThreadSafe
public class StreamedMessagesWriter
extends StreamedMessagesAccess {
    private volatile Streamer.Output _output;

    @CheckReturnValue
    public synchronized boolean add(@Nonnull Serializable message) {
        return this._output.add(message);
    }

    public void close() {
        Streamer.Output output = this._output;
        if (output != null) {
            output.close();
            this._output = null;
        }
    }

    public synchronized void flush() {
        this._output.flush();
    }

    public synchronized void open(@Nonnull Writer writer) {
        Require.equal(null, this._output);
        this._output = this.getStreamer().newOutput(writer);
    }

    public synchronized void open(@Nonnull XMLElement parentElement) {
        Require.equal(null, this._output);
        this._output = this.getStreamer().newOutput(parentElement);
    }

    public synchronized void open(@Nonnull File file, @Nonnull Optional<Charset> charset) throws FileNotFoundException {
        Require.equal(null, this._output);
        this._output = this.getStreamer().newOutput(file, charset);
    }

    public synchronized void open(@Nonnull OutputStream outputStream, @Nonnull Optional<Charset> charset) {
        Require.equal(null, this._output);
        this._output = this.getStreamer().newOutput(outputStream, charset);
    }

    @Override
    public void tearDown() {
        this.close();
        super.tearDown();
    }
}

