/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.base.xml.streamer.xstream.XStreamStreamer;

@NotThreadSafe
public abstract class Streamer {
    @Nonnull
    @CheckReturnValue
    public static Streamer newInstance() {
        return new XStreamStreamer();
    }

    @Nullable
    @CheckReturnValue
    public Serializable fromXML(@Nonnull XMLElement xmlElement) {
        XMLElement parentElement = new XMLElement("");
        parentElement.addChild(Require.notNull(xmlElement));
        Input input = this.newInput(parentElement);
        Serializable serializable = input.next();
        input.close();
        return serializable;
    }

    @Nonnull
    @CheckReturnValue
    public abstract Input newInput(@Nonnull Reader var1);

    @Nonnull
    @CheckReturnValue
    public Input newInput(@Nonnull XMLDocument xmlDocument) {
        return this.newInput(new XMLElement("", xmlDocument.getRootElement()));
    }

    @Nonnull
    @CheckReturnValue
    public abstract Input newInput(@Nonnull XMLElement var1);

    @Nonnull
    @CheckReturnValue
    public abstract Input newInput(@Nonnull File var1, @Nonnull Optional<Charset> var2) throws FileNotFoundException;

    @Nonnull
    @CheckReturnValue
    public abstract Input newInput(@Nonnull InputStream var1, @Nonnull Optional<Charset> var2);

    @Nonnull
    @CheckReturnValue
    public abstract Output newOutput(@Nonnull Writer var1);

    @Nonnull
    @CheckReturnValue
    public abstract Output newOutput(@Nonnull XMLElement var1);

    @Nonnull
    @CheckReturnValue
    public abstract Output newOutput(@Nonnull File var1, @Nonnull Optional<Charset> var2) throws FileNotFoundException;

    @Nonnull
    @CheckReturnValue
    public abstract Output newOutput(@Nonnull OutputStream var1, @Nonnull Optional<Charset> var2);

    @CheckReturnValue
    public abstract boolean setUp(@Nonnull Optional<KeyedGroups> var1, @Nonnull Optional<KeyedValues> var2);

    public abstract void tearDown();

    @Nonnull
    @CheckReturnValue
    public XMLElement toXML(@Nullable Serializable serializable) {
        XMLElement parentElement = new XMLElement("");
        Output output = this.newOutput(parentElement);
        Require.success(output.add(serializable));
        output.close();
        return parentElement.getChild(0);
    }

    public static abstract class Output {
        private final Writer _writer;

        protected Output() {
            this._writer = null;
        }

        protected Output(@Nonnull Writer writer) {
            this._writer = new _NoCloseWriter(writer);
        }

        protected Output(@Nonnull File file, @Nonnull Optional<Charset> charset) throws FileNotFoundException {
            this._writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset.isPresent() ? charset.get() : StandardCharsets.UTF_8);
        }

        protected Output(@Nonnull OutputStream outputStream, @Nonnull Optional<Charset> charset) {
            this._writer = new _NoCloseWriter(new OutputStreamWriter(outputStream, charset.isPresent() ? charset.get() : StandardCharsets.UTF_8));
        }

        @CheckReturnValue
        public abstract boolean add(Serializable var1);

        public abstract void close();

        public abstract void flush();

        @Nonnull
        @CheckReturnValue
        protected Optional<Writer> getWriter() {
            return Optional.ofNullable(this._writer);
        }

        @CheckReturnValue
        protected boolean validate(Serializable serializable) {
            if (serializable instanceof Validated) {
                return ((Validated)((Object)serializable)).validate();
            }
            return true;
        }

        private static class _NoCloseWriter
        extends FilterWriter {
            _NoCloseWriter(@Nonnull Writer writer) {
                super(writer);
            }

            @Override
            public void close() {
            }
        }
    }

    public static abstract class Input
    implements Iterator<Serializable>,
    Iterable<Serializable> {
        private final Reader _reader;

        protected Input() {
            this._reader = null;
        }

        protected Input(@Nonnull Reader reader) {
            this._reader = reader;
        }

        protected Input(@Nonnull File file, @Nonnull Optional<Charset> charset) throws FileNotFoundException {
            this(new FileInputStream(file), charset);
        }

        protected Input(@Nonnull InputStream inputStream, @Nonnull Optional<Charset> charset) {
            this._reader = new InputStreamReader(inputStream, charset.isPresent() ? charset.get() : StandardCharsets.UTF_8);
        }

        public abstract void close();

        @Override
        public Iterator<Serializable> iterator() {
            return this;
        }

        @Override
        public abstract Serializable next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @CheckReturnValue
        public abstract boolean skip();

        @Nonnull
        @CheckReturnValue
        protected Optional<Reader> getReader() {
            return Optional.ofNullable(this._reader);
        }
    }

    public static interface Validated {
        @CheckReturnValue
        public boolean validate();
    }
}

