/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.VersionedValue;
import org.rvpf.base.xml.streamer.StreamedMessagesPortClient;

@NotThreadSafe
public final class XMLPointValuesPortClient
extends StreamedMessagesPortClient {
    public static final String DELETED_STATE = "deleted";

    public XMLPointValuesPortClient(@Nonnull String client) {
        super(client);
    }

    @Override
    public void close() {
        super.close();
        this.tearDown();
    }

    @Override
    public void open(String addressString, Optional<SecurityContext> securityContext) throws ServiceNotAvailableException {
        if (!this.setUp(Optional.empty(), Optional.empty())) {
            throw new ServiceNotAvailableException();
        }
        super.open(addressString, securityContext);
    }

    public void sendValue(@Nonnull PointValue pointValue) throws IOException {
        if (pointValue.getState() == DELETED_STATE && !(pointValue instanceof VersionedValue.Deleted)) {
            pointValue = new VersionedValue.Deleted(pointValue);
        }
        this.addMessage(pointValue);
    }

    public void sendValue(@Nonnull String point, @Nonnull String stamp, @Nonnull Optional<String> state, @Nonnull Optional<String> value) throws IOException {
        PointValue pointValue = new PointValue(point, Optional.of(DateTime.now().valueOf(stamp)), (Serializable)state.orElse(null), (Serializable)value.orElse(null));
        this.sendValue(pointValue);
    }
}

