/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer.xstream;

import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.xml.AbstractDocumentReader;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;
import org.rvpf.base.xml.XMLAttribute;
import org.rvpf.base.xml.XMLElement;

@NotThreadSafe
final class ElementReader
extends AbstractDocumentReader {
    private List<XMLAttribute> _currentAttributes;
    private XMLElement _currentElement;
    private final FastStack _elementStack = new FastStack(4);

    ElementReader(@Nonnull XMLElement rootElement) {
        super(Require.notNull(rootElement));
    }

    @Override
    public String getAttribute(int index) {
        if (this._currentAttributes == null) {
            this._currentAttributes = this._currentElement.getAttributes();
        }
        return this._currentAttributes.get(index).getValue();
    }

    @Override
    public String getAttribute(String name) {
        return this._currentElement.getAttributeValue(name, Optional.empty()).orElse(null);
    }

    @Override
    public int getAttributeCount() {
        return this._currentElement.getAttributeCount();
    }

    @Override
    public String getAttributeName(int index) {
        if (this._currentAttributes == null) {
            this._currentAttributes = this._currentElement.getAttributes();
        }
        return this._currentAttributes.get(index).getName();
    }

    @Override
    public String getNodeName() {
        return this._currentElement.getName();
    }

    @Override
    public String getValue() {
        return this._currentElement.getText();
    }

    @Override
    protected Object getChild(int index) {
        this._elementStack.push(this._currentElement);
        return this._currentElement.getChild(index);
    }

    @Override
    protected int getChildCount() {
        return this._currentElement.getChildCount();
    }

    @Override
    protected Object getParent() {
        return this._elementStack.pop();
    }

    @Override
    protected void reassignCurrentElement(Object current) {
        this._currentElement = (XMLElement)current;
        this._currentAttributes = null;
    }
}

