/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDef;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.base.xml.streamer.Streamer;
import org.rvpf.base.xml.streamer.xstream.ElementReader;
import org.rvpf.base.xml.streamer.xstream.ElementWriter;
import org.rvpf.base.xml.streamer.xstream.converter.AlertConverter;
import org.rvpf.base.xml.streamer.xstream.converter.BigRationalConverter;
import org.rvpf.base.xml.streamer.xstream.converter.ComplexConverter;
import org.rvpf.base.xml.streamer.xstream.converter.DateTimeConverter;
import org.rvpf.base.xml.streamer.xstream.converter.DictConverter;
import org.rvpf.base.xml.streamer.xstream.converter.DoubleConverter;
import org.rvpf.base.xml.streamer.xstream.converter.EncryptedConverter;
import org.rvpf.base.xml.streamer.xstream.converter.FloatConverter;
import org.rvpf.base.xml.streamer.xstream.converter.PointValueConverter;
import org.rvpf.base.xml.streamer.xstream.converter.RationalConverter;
import org.rvpf.base.xml.streamer.xstream.converter.SignedConverter;
import org.rvpf.base.xml.streamer.xstream.converter.StateConverter;
import org.rvpf.base.xml.streamer.xstream.converter.TupleConverter;
import org.rvpf.base.xml.streamer.xstream.converter.UUIDConverter;

@NotThreadSafe
public final class XStreamStreamer
extends Streamer {
    public static final String ANNOTATED_CLASS_PROPERTY = "xstream.annotated.class";
    public static final String CONVERTER_CLASS_PROPERTY = "xstream.converter.class";
    public static final String REFERENCES_PROPERTY = "references";
    public static final String ROOT_ELEMENT = "rvpf-data";
    private static final Logger _LOGGER = Logger.getInstance(XStreamStreamer.class);
    private final Set<Converter> _converters = new HashSet<Converter>();
    private StaxDriver _driver;
    private XStream _xstream;

    @CheckReturnValue
    public XStream getXStream() {
        return this._xstream;
    }

    @Override
    public Streamer.Input newInput(Reader reader) {
        return new _InputImpl(reader);
    }

    @Override
    public Streamer.Input newInput(XMLElement parentElement) {
        return new _InputImpl(parentElement);
    }

    @Override
    public Streamer.Input newInput(File file, Optional<Charset> charset) throws FileNotFoundException {
        return new _InputImpl(file, charset);
    }

    @Override
    public Streamer.Input newInput(InputStream inputStream, Optional<Charset> charset) {
        return new _InputImpl(inputStream, charset);
    }

    @Override
    public Streamer.Output newOutput(Writer writer) {
        return new _OutputImpl(writer);
    }

    @Override
    public Streamer.Output newOutput(XMLElement parentElement) {
        return new _OutputImpl(parentElement);
    }

    @Override
    public Streamer.Output newOutput(File file, Optional<Charset> charset) throws FileNotFoundException {
        return new _OutputImpl(file, charset);
    }

    @Override
    public Streamer.Output newOutput(OutputStream outputStream, Optional<Charset> charset) {
        return new _OutputImpl(outputStream, charset);
    }

    @Override
    public boolean setUp(Optional<KeyedGroups> configProperties, Optional<KeyedValues> moduleProperties) {
        this._driver = new StaxDriver();
        this._xstream = new XStream(null, (HierarchicalStreamDriver)this._driver, new ClassLoaderReference(Thread.currentThread().getContextClassLoader()));
        XStream.setupDefaultSecurity(this._xstream);
        this._xstream.addPermission(AnyTypePermission.ANY);
        if (!moduleProperties.isPresent() || !moduleProperties.get().getBoolean(REFERENCES_PROPERTY)) {
            this._xstream.setMode(1001);
        }
        if (!this._registerConverter(new PointValueConverter())) {
            return false;
        }
        if (!this._registerConverter(new AlertConverter())) {
            return false;
        }
        if (!this._registerConverter(new UUIDConverter())) {
            return false;
        }
        if (!this._registerConverter(new DoubleConverter())) {
            return false;
        }
        if (!this._registerConverter(new FloatConverter())) {
            return false;
        }
        if (!this._registerConverter(new StateConverter())) {
            return false;
        }
        if (!this._registerConverter(new ComplexConverter())) {
            return false;
        }
        if (!this._registerConverter(new RationalConverter())) {
            return false;
        }
        if (!this._registerConverter(new BigRationalConverter())) {
            return false;
        }
        if (!this._registerConverter(new DateTimeConverter())) {
            return false;
        }
        if (!this._registerConverter(new TupleConverter(this._xstream.getMapper()))) {
            return false;
        }
        if (!this._registerConverter(new DictConverter(this._xstream.getMapper()))) {
            return false;
        }
        if (!this._registerConverter(new EncryptedConverter())) {
            return false;
        }
        if (!this._registerConverter(new SignedConverter())) {
            return false;
        }
        if (configProperties.isPresent()) {
            for (ClassDef converterClassDef : configProperties.get().getClassDefs(CONVERTER_CLASS_PROPERTY)) {
                if (this._registerConverter(converterClassDef)) continue;
                return false;
            }
            for (ClassDef classDef : configProperties.get().getClassDefs(ANNOTATED_CLASS_PROPERTY)) {
                if (this._registerAnnotations(classDef)) continue;
                return false;
            }
        }
        if (moduleProperties.isPresent()) {
            for (ClassDef converterClassDef : moduleProperties.get().getClassDefs(CONVERTER_CLASS_PROPERTY)) {
                if (this._registerConverter(converterClassDef)) continue;
                return false;
            }
            for (ClassDef classDef : moduleProperties.get().getClassDefs(ANNOTATED_CLASS_PROPERTY)) {
                if (this._registerAnnotations(classDef)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void tearDown() {
        for (Converter converter : this._converters) {
            converter.tearDown();
        }
        this._converters.clear();
        this._xstream = null;
        this._driver = null;
    }

    @Nonnull
    @CheckReturnValue
    StaxDriver getDriver() {
        return Require.notNull(this._driver);
    }

    private boolean _registerAnnotations(ClassDef classDef) {
        Class<?> streamedClass = classDef.getInstanceClass();
        if (streamedClass == null) {
            _LOGGER.warn(BaseMessages.ANNOTATIONS_REGISTRATION, classDef.getClassName());
            return false;
        }
        this._xstream.processAnnotations(streamedClass);
        _LOGGER.trace(BaseMessages.REGISTERED_ANNOTATIONS, streamedClass.getName());
        return true;
    }

    private boolean _registerConverter(ClassDef classDef) {
        Converter converterInstance = classDef.createInstance(Converter.class);
        return this._registerConverter(Require.notNull(converterInstance));
    }

    private boolean _registerConverter(Converter converter) {
        if (!converter.setUp(this)) {
            return false;
        }
        if (this._converters.add(converter)) {
            _LOGGER.trace(BaseMessages.REGISTERED_CONVERTER, converter.getClass().getName());
        }
        return true;
    }

    static {
        InputStream inputStream = XStream.class.getResourceAsStream("/META-INF/maven/com.thoughtworks.xstream/xstream/pom.properties");
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = properties.getProperty("version");
            if (version != null) {
                _LOGGER.debug(BaseMessages.XSTREAM_VERSION, version);
            }
        }
    }

    private static final class _Wrapper
    extends Reader {
        private final LinkedList<Reader> _readers = new LinkedList();

        _Wrapper(@Nonnull Reader reader) {
            this._readers.add(new StringReader("<rvpf-data>"));
            this._readers.add(reader);
            this._readers.add(new StringReader("</rvpf-data>"));
        }

        @Override
        public void close() throws IOException {
            while (!this._readers.isEmpty()) {
                Reader reader = this._readers.remove();
                reader.close();
            }
        }

        @Override
        public int read(char[] buffer, int offset, int length) throws IOException {
            while (!this._readers.isEmpty()) {
                int read = this._readers.getFirst().read(buffer, offset, length);
                if (read > 0) {
                    return read;
                }
                this._readers.removeFirst().close();
            }
            return -1;
        }
    }

    private final class _OutputImpl
    extends Streamer.Output {
        private HierarchicalStreamWriter _streamerWriter;
        private XMLStreamWriter _xmlStreamWriter;

        _OutputImpl(Writer writer) {
            super(writer);
            this._init();
        }

        _OutputImpl(XMLElement parentElement) {
            this._streamerWriter = new ElementWriter(Require.notNull(parentElement));
        }

        _OutputImpl(@Nonnull File file, Optional<Charset> charset) throws FileNotFoundException {
            super(file, charset);
            this._init();
        }

        _OutputImpl(@Nonnull OutputStream outputStream, Optional<Charset> charset) {
            super(outputStream, charset);
            this._init();
        }

        @Override
        public boolean add(Serializable serializable) {
            if (!this.validate(serializable)) {
                return false;
            }
            XStreamStreamer.this.getXStream().marshal(serializable, this._streamerWriter);
            if (this._xmlStreamWriter != null) {
                try {
                    this._xmlStreamWriter.writeCharacters("\n");
                }
                catch (XMLStreamException exception) {
                    throw new StreamException(exception);
                }
            }
            return true;
        }

        @Override
        public void close() {
            this.flush();
            this._streamerWriter.close();
            if (this.getWriter().isPresent()) {
                try {
                    this.getWriter().get().close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        @Override
        public void flush() {
            this._streamerWriter.flush();
        }

        private void _init() {
            try {
                this._xmlStreamWriter = XStreamStreamer.this.getDriver().getOutputFactory().createXMLStreamWriter(this.getWriter().get());
                this._streamerWriter = XStreamStreamer.this.getDriver().createStaxWriter(this._xmlStreamWriter, false);
            }
            catch (XMLStreamException exception) {
                throw new StreamException(exception);
            }
        }
    }

    private final class _InputImpl
    extends Streamer.Input {
        private HierarchicalStreamReader _streamerReader;
        private _Wrapper _wrapper;

        _InputImpl(Reader reader) {
            super(reader);
            this._init();
        }

        _InputImpl(XMLElement parentElement) {
            this._streamerReader = new ElementReader(parentElement);
        }

        _InputImpl(@Nonnull File file, Optional<Charset> charset) throws FileNotFoundException {
            super(file, charset);
            this._init();
        }

        _InputImpl(@Nonnull InputStream inputStream, Optional<Charset> charset) {
            super(inputStream, charset);
            this._init();
        }

        @Override
        public void close() {
            this._streamerReader.close();
            if (this._wrapper != null) {
                try {
                    this._wrapper.close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this._streamerReader.hasMoreChildren();
        }

        @Override
        public Serializable next() {
            if (!this._streamerReader.hasMoreChildren()) {
                throw new NoSuchElementException();
            }
            this._streamerReader.moveDown();
            Serializable next = (Serializable)XStreamStreamer.this.getXStream().unmarshal(this._streamerReader);
            this._streamerReader.moveUp();
            return next;
        }

        @Override
        public boolean skip() {
            boolean skipped;
            if (this._streamerReader.hasMoreChildren()) {
                this._streamerReader.moveDown();
                this._streamerReader.moveUp();
                skipped = true;
            } else {
                skipped = false;
            }
            return skipped;
        }

        private void _init() {
            this._wrapper = new _Wrapper(this.getReader().get());
            this._streamerReader = XStreamStreamer.this.getDriver().createReader(this._wrapper);
        }
    }

    public static interface Converter {
        @CheckReturnValue
        public boolean setUp(@Nonnull XStreamStreamer var1);

        public void tearDown();
    }
}

