/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer.xstream.converter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.Serializable;
import java.util.Map;
import org.rvpf.base.value.Dict;
import org.rvpf.base.xml.streamer.xstream.XStreamStreamer;

public class DictConverter
extends MapConverter
implements XStreamStreamer.Converter {
    public static final String DICT_ELEMENT = "dict";
    public static final String KEY_ELEMENT = "key";

    public DictConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(Dict.class);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        for (Map.Entry entry : ((Map)source).entrySet()) {
            writer.startNode(KEY_ELEMENT);
            writer.setValue((String)entry.getKey());
            writer.endNode();
            this.writeItem(entry.getValue(), context, writer);
        }
    }

    @Override
    public boolean setUp(XStreamStreamer streamer) {
        XStream xstream = streamer.getXStream();
        xstream.registerConverter(this, 1);
        xstream.alias(DICT_ELEMENT, Dict.class);
        return true;
    }

    @Override
    public void tearDown() {
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Dict dict = (Dict)super.unmarshal(reader, context);
        dict.freeze();
        return dict;
    }

    @Override
    protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!reader.getNodeName().equals(KEY_ELEMENT)) {
                throw new XStreamException(reader.getNodeName());
            }
            String key = reader.getValue();
            reader.moveUp();
            reader.moveDown();
            Serializable value = (Serializable)this.readItem(reader, context, map);
            reader.moveUp();
            target.put(key, value);
        }
    }
}

