/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.xml.streamer.xstream.converter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.util.Mappable;
import org.rvpf.base.value.Tuple;
import org.rvpf.base.xml.streamer.xstream.XStreamStreamer;

@NotThreadSafe
public abstract class MappableConverter
implements Converter,
XStreamStreamer.Converter {
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String TYPE_ATTRIBUTE = "type";
    private XStream _xstream;

    @Override
    public final void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        ((Mappable)source).writeMap(new _WriterMap(writer, context));
    }

    @Override
    public boolean setUp(XStreamStreamer streamer) {
        this._xstream = streamer.getXStream();
        this._xstream.registerConverter(this, 1);
        return true;
    }

    @Override
    public void tearDown() {
    }

    @Override
    public final Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Mappable mappable;
        Class type = context.getRequiredType();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try {
            mappable = (Mappable)type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new ConversionException(exception);
        }
        Iterator attributeIterator = reader.getAttributeNames();
        while (attributeIterator.hasNext()) {
            String attributeName = (String)attributeIterator.next();
            map.put(attributeName, (Serializable)((Object)reader.getAttribute(attributeName)));
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String className = reader.getAttribute(CLASS_ATTRIBUTE);
            if (className == null) {
                className = reader.getAttribute(TYPE_ATTRIBUTE);
            }
            Object value = className != null ? (Serializable)context.convertAnother(mappable, this.getXStream().getMapper().realClass(className)) : (reader.hasMoreChildren() ? (Serializable)context.convertAnother(mappable, LinkedList.class) : reader.getValue());
            map.put(reader.getNodeName(), (Serializable)value);
            reader.moveUp();
        }
        mappable.readMap(map);
        return mappable;
    }

    protected final XStream getXStream() {
        return this._xstream;
    }

    @NotThreadSafe
    private final class _WriterMap
    extends AbstractMap<String, Serializable> {
        private boolean _attributeMode;
        private final MarshallingContext _context;
        private final HierarchicalStreamWriter _writer;

        _WriterMap(@Nonnull HierarchicalStreamWriter writer, MarshallingContext context) {
            this._writer = writer;
            this._context = context;
        }

        @Override
        public Set<Map.Entry<String, Serializable>> entrySet() {
            return null;
        }

        @Override
        public Serializable put(String key, Serializable value) {
            if (value == null) {
                if (key == "") {
                    this._attributeMode = true;
                } else if (key == Mappable.SERIALIZABLE_MODE) {
                    this._attributeMode = false;
                }
                return null;
            }
            if (this._attributeMode) {
                this._writer.addAttribute(key, (String)((Object)value));
            } else {
                this._writer.startNode(key);
                if (!(value instanceof Collection) || value.getClass() == Tuple.class) {
                    this._writer.addAttribute(MappableConverter.CLASS_ATTRIBUTE, MappableConverter.this.getXStream().getMapper().serializedClass(value.getClass()));
                }
                this._context.convertAnother(value);
                this._writer.endNode();
            }
            return null;
        }
    }
}

