/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.jnlp;

import java.util.Optional;
import org.rvpf.base.logger.Messages;
import org.rvpf.http.HTTPServerActivator;
import org.rvpf.http.HTTPServerImpl;
import org.rvpf.jnlp.launcher.Launcher;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.ServiceMessages;
import org.rvpf.tests.service.ServiceTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class LauncherTests
extends ServiceTests
implements Runnable {
    public static final String CACHE_DIR = "tests/data/cache";
    public static final String SERVER_PORT_PROPERTY = "server.port";
    private static final String _FORWARDER_ACTIVATOR = "org.rvpf.forwarder.ForwarderServiceActivator";
    private static final String _TRUST_STORE = "tests/config/client.truststore";
    private static final String _TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    private ServiceActivator _server;
    private int _serverPort;

    @Override
    public void run() {
        String[] args = new String[]{"http://localhost:" + this._serverPort + "/tests-service.jnlp", _FORWARDER_ACTIVATOR};
        Launcher.main((String[])args);
    }

    @BeforeClass
    public void setUp() throws Exception {
        this._server = this.createService(HTTPServerActivator.class, Optional.empty());
        LauncherTests.startService((ServiceActivator)this._server);
        this.setUpAlerter();
        this._serverPort = ((HTTPServerImpl)this._server.getService()).getListenerPort(0);
        LauncherTests.setSystemProperty((String)"rvpf.jnlp.server.port", (String)String.valueOf(this._serverPort));
        LauncherTests.setSystemProperty((String)"rvpf.jnlp.cache.dir", (String)CACHE_DIR);
        LauncherTests.setSystemProperty((String)"rvpf.jnlp.cache.purge", (String)"true");
        LauncherTests.setSystemProperty((String)_TRUST_STORE_PROPERTY, (String)_TRUST_STORE);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.tearDownAlerter();
        if (this._server != null) {
            this.stopService(this._server);
            this._server = null;
        }
    }

    @Test
    public void test() throws Exception {
        this.expectEvents(new String[]{"ServiceStarted"});
        Thread thread = new Thread(this);
        thread.start();
        this.waitForEvent("ServiceStarted");
        this.quell(new Messages.Entry[]{ServiceMessages.REGISTRY_EXPORT_PURGED, ServiceMessages.RMI_NOT_BOUND, ServiceMessages.RMI_NOT_REGISTERED});
        this.sendSignal("Stop", Optional.empty());
        thread.join();
    }
}

