/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDef;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;

@ThreadSafe
public final class ClassDefImpl
implements ClassDef {
    private volatile Class<?> _class;
    private final String _member;
    private final String _packageName;

    public ClassDefImpl(@Nonnull Class<?> aClass) {
        this(aClass.getName());
        this._class = aClass;
    }

    public ClassDefImpl(@Nonnull String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            this._packageName = className.substring(0, index).trim();
            this._member = className.substring(index + 1).trim();
        } else {
            this._packageName = null;
            this._member = className.trim();
        }
    }

    public ClassDefImpl(@Nonnull String packageName, @Nonnull String member) {
        this._packageName = (String)Require.notNull((Object)packageName);
        this._member = (String)Require.notNull((Object)member);
    }

    @Override
    public <T> T createInstance(Class<T> expectedClass) {
        T instance = null;
        if (this.getInstanceClass() != null) {
            if (expectedClass.isAssignableFrom(this._class)) {
                try {
                    instance = (T)this._class.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    Throwable cause = exception.getCause();
                    this._getLogger().error(BaseMessages.INSTANTIATION_FAILED, this.getClassName(), cause != null ? cause : exception);
                }
            } else {
                this._getLogger().error(BaseMessages.CLASS_NOT_COMPATIBLE, this._class.getName(), expectedClass.getName());
            }
        }
        return instance;
    }

    @Override
    public String getClassName() {
        return this._packageName != null ? this._packageName + '.' + this._member : this._member;
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.getInstanceClass(Optional.ofNullable(Thread.currentThread().getContextClassLoader()));
    }

    @Override
    public Class<?> getInstanceClass(Optional<ClassLoader> classLoader) {
        Class<?> instanceClass = this._class;
        if (instanceClass == null) {
            try {
                instanceClass = Class.forName(this.getClassName(), true, classLoader.orElse(null));
            }
            catch (ClassNotFoundException exception) {
                this._getLogger().warn(BaseMessages.CLASS_NOT_FOUND, this.getClassName());
            }
            this._class = instanceClass;
        }
        return instanceClass;
    }

    @Override
    public String getMember() {
        return this._member;
    }

    @Override
    public String getPackageName() {
        return this._packageName;
    }

    @Override
    public boolean isLoaded() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof ClassDef.Loader) {
            return ((ClassDef.Loader)classLoader).isLoaded(this.getClassName());
        }
        return false;
    }

    public String toString() {
        return this.getClassName();
    }

    private Logger _getLogger() {
        return Logger.getInstance(this.getClass());
    }
}

