/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;

@Immutable
public final class DateTime
implements Serializable,
Comparable<DateTime> {
    public static final DateTime BEGINNING_OF_TIME;
    public static final String BEGINNING_OF_TIME_STRING = "BoT";
    public static final DateTime END_OF_TIME;
    public static final String END_OF_TIME_STRING = "EoT";
    public static final int FILE_NAME_LENGTH = 23;
    public static final DateTime INVALID;
    public static final DateTime MJD_EPOCH;
    public static final DateTime UNIX_EPOCH;
    public static final Context UTC_CONTEXT;
    public static final DateTime WINDOWS_EPOCH;
    private static final long _BEGINNING_OF_TIME_RAW = -4611686018427387904L;
    private static final Context _DEFAULT_CONTEXT;
    private static final long _END_OF_TIME_RAW = 0x3FFFFFFFFFFFFFFFL;
    private static final long _INVALID_RAW = Long.MIN_VALUE;
    private static final long _MJD_EPOCH_RAW = 0L;
    private static final long _UNIX_EPOCH_RAW = 35067168000000000L;
    private static final long _WINDOWS_EPOCH_RAW = -81377568000000000L;
    private static volatile Context _defaultContext;
    private static volatile DateTime _simulatedTime;
    private static final long serialVersionUID = 1L;
    private final long _raw;

    private DateTime(long raw) {
        this._raw = raw;
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime at(@Nonnull Timestamp timestamp) {
        long milliRaw = ElapsedTime.MILLI.toRaw();
        long time = timestamp.getTime() * milliRaw;
        return DateTime._fromRaw((time += (long)(timestamp.getNanos() / 100) % milliRaw) + 35067168000000000L);
    }

    public static void clearSimulatedTime() {
        _simulatedTime = null;
    }

    @Nonnull
    @CheckReturnValue
    public static Context defaultContext() {
        return _defaultContext;
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromBytes(@Nonnull byte[] bytes) {
        long raw = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            raw <<= 8;
            raw |= (long)(bytes[i] & 0xFF);
        }
        return DateTime._fromRaw(raw);
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromDataInput(@Nonnull DataInput source) throws IOException {
        long raw = source.readLong();
        return raw == INVALID.toRaw() ? INVALID : DateTime._fromRaw(raw);
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromFields(@Nonnull Fields fields) {
        return DateTime.defaultContext().fromFields(fields);
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromInstant(@Nonnull Instant instant) {
        long secondsRaw = instant.getEpochSecond() * ElapsedTime.SECOND.toRaw();
        long unixRaw = secondsRaw + (long)(instant.getNano() / 100);
        return DateTime._fromRaw(unixRaw + 35067168000000000L);
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromMillis(long millis) {
        return DateTime._fromRaw(millis * ElapsedTime.MILLI.toRaw() + 35067168000000000L);
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromRaw(long raw) {
        return DateTime._fromRaw(raw);
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<DateTime> fromString(@Nonnull Optional<String> timeString) {
        return timeString.isPresent() && !timeString.get().isEmpty() ? Optional.of(DateTime.fromString(timeString.get())) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromString(@Nonnull String timeString) {
        return DateTime.defaultContext().fromString(timeString);
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromWin32(long win32) {
        return DateTime._fromRaw(win32 + -81377568000000000L);
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime fromZonedDateTime(@Nonnull ZonedDateTime zonedDateTime) {
        return DateTime.fromInstant(zonedDateTime.toInstant());
    }

    @Nonnull
    @CheckReturnValue
    public static TimeZone getTimeZone() {
        return DateTime.defaultContext().getTimeZone();
    }

    @Nonnull
    @CheckReturnValue
    public static ZoneId getZoneId() {
        return DateTime.defaultContext().getZoneId();
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime max(@Nonnull Collection<DateTime> dateTimes) {
        Require.failure((boolean)dateTimes.isEmpty());
        DateTime max = null;
        for (DateTime dateTime : dateTimes) {
            if (max != null && !dateTime.isAfter(max)) continue;
            max = dateTime;
        }
        return max;
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime max(DateTime ... dateTimes) {
        Require.success((dateTimes.length > 0 ? 1 : 0) != 0);
        DateTime max = null;
        for (DateTime dateTime : dateTimes) {
            if (max != null && !dateTime.isAfter(max)) continue;
            max = dateTime;
        }
        return max;
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime min(@Nonnull Collection<DateTime> dateTimes) {
        Require.failure((boolean)dateTimes.isEmpty());
        DateTime min = null;
        for (DateTime dateTime : dateTimes) {
            if (min != null && !dateTime.isBefore(min)) continue;
            min = dateTime;
        }
        return min;
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime min(DateTime ... dateTimes) {
        Require.success((dateTimes.length > 0 ? 1 : 0) != 0);
        DateTime min = null;
        for (DateTime dateTime : dateTimes) {
            if (min != null && !dateTime.isBefore(min)) continue;
            min = dateTime;
        }
        return min;
    }

    @Nonnull
    @CheckReturnValue
    public static DateTime now() {
        DateTime simulated = _simulatedTime;
        return simulated == null ? DateTime.fromMillis(System.currentTimeMillis()) : simulated;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<DateTime> readExternal(@Nonnull ObjectInput source) throws IOException {
        DateTime dateTime = DateTime.fromDataInput(source);
        return dateTime.isInvalid() ? Optional.empty() : Optional.of(dateTime);
    }

    public static void resetTimeZone() {
        _defaultContext = _DEFAULT_CONTEXT;
    }

    public static void simulateTime(@Nonnull DateTime simulatedTime) {
        _simulatedTime = (DateTime)Require.notNull((Object)simulatedTime);
    }

    public static void simulateTimeZone(@Nonnull TimeZone timeZone) {
        _defaultContext = new Context(timeZone);
    }

    public static void writeExternal(@Nonnull Optional<DateTime> dateTime, @Nonnull ObjectOutput destination) throws IOException {
        (dateTime.isPresent() ? dateTime.get() : INVALID).toDataOutput(destination);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime after() {
        if (this._raw == -4611686018427387904L || this._raw == 0x3FFFFFFFFFFFFFFFL) {
            return this;
        }
        return this.after(1L);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime after(@Nonnull DateTime limit) {
        return this.isAfter(limit) ? this : limit.after();
    }

    @Nonnull
    @CheckReturnValue
    public DateTime after(@Nonnull ElapsedTime elapsed) {
        return elapsed.isInfinity() ? END_OF_TIME : this.after(elapsed.toRaw());
    }

    @Nonnull
    @CheckReturnValue
    public DateTime after(long interval) {
        return interval < 0L ? this.before(-interval) : DateTime._fromRaw(this._raw + interval);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime before() {
        if (this._raw == -4611686018427387904L || this._raw == 0x3FFFFFFFFFFFFFFFL) {
            return this;
        }
        return this.before(1L);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime before(@Nonnull DateTime limit) {
        return this.isBefore(limit) ? this : limit.before();
    }

    @Nonnull
    @CheckReturnValue
    public DateTime before(@Nonnull ElapsedTime elapsed) {
        return elapsed.isInfinity() ? BEGINNING_OF_TIME : this.before(elapsed.toRaw());
    }

    @Nonnull
    @CheckReturnValue
    public DateTime before(long interval) {
        if (interval < 0L) {
            if (interval == Long.MIN_VALUE) {
                throw new IllegalArgumentException(Message.format(BaseMessages.TIME_INTERVAL, new Object[0]));
            }
            return this.after(-interval);
        }
        return DateTime._fromRaw(this._raw - interval);
    }

    @Override
    public int compareTo(DateTime other) {
        return Long.compare(this.toRaw(), other.toRaw());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DateTime) {
            return this.toRaw() == ((DateTime)other).toRaw();
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public DateTime floored(@Nonnull ElapsedTime whole) {
        return this.floored(whole.toRaw());
    }

    @Nonnull
    @CheckReturnValue
    public DateTime floored(long whole) {
        Require.success((whole > 0L ? 1 : 0) != 0);
        return this.before(this._raw >= 0L ? this._raw % whole : whole + this._raw % whole);
    }

    @CheckReturnValue
    public int getDayOfWeek() {
        return DateTime.defaultContext().getDayOfWeek(this);
    }

    public int hashCode() {
        return (int)(this._raw ^ this._raw >>> 32);
    }

    @CheckReturnValue
    public boolean isAfter(@Nonnull DateTime other) {
        return this.toRaw() > other.toRaw();
    }

    @CheckReturnValue
    public boolean isAfter(@Nonnull TimeInterval interval) {
        Optional before = interval.getBefore();
        return before.isPresent() && this._raw >= ((DateTime)before.get()).toRaw();
    }

    @CheckReturnValue
    public boolean isAtBeginning(@Nonnull TimeInterval interval) {
        Optional after = interval.getAfter();
        return after.isPresent() && this._raw == ((DateTime)after.get()).toRaw() + 1L;
    }

    @CheckReturnValue
    public boolean isAtEnd(@Nonnull TimeInterval interval) {
        Optional before = interval.getBefore();
        return before.isPresent() && this._raw == ((DateTime)before.get()).toRaw() - 1L;
    }

    @CheckReturnValue
    public boolean isBefore(@Nonnull DateTime other) {
        return this.toRaw() < other.toRaw();
    }

    @CheckReturnValue
    public boolean isBefore(@Nonnull TimeInterval interval) {
        Optional after = interval.getAfter();
        return after.isPresent() && this._raw <= ((DateTime)after.get()).toRaw();
    }

    @CheckReturnValue
    public boolean isBeginningOfTime() {
        return this._raw == -4611686018427387904L;
    }

    @CheckReturnValue
    public boolean isEndOfTime() {
        return this._raw == 0x3FFFFFFFFFFFFFFFL;
    }

    @CheckReturnValue
    public boolean isInside(@Nonnull TimeInterval interval) {
        Optional before;
        Optional after = interval.getAfter();
        return !(after.isPresent() && this._raw <= ((DateTime)after.get()).toRaw() || (before = interval.getBefore()).isPresent() && this._raw >= ((DateTime)before.get()).toRaw());
    }

    @CheckReturnValue
    public boolean isInvalid() {
        return this == INVALID;
    }

    @CheckReturnValue
    public boolean isNotAfter(@Nonnull DateTime other) {
        return this.toRaw() <= other.toRaw();
    }

    @CheckReturnValue
    public boolean isNotAfter(@Nonnull TimeInterval interval) {
        Optional before = interval.getBefore();
        return !before.isPresent() || this._raw < ((DateTime)before.get()).toRaw();
    }

    @CheckReturnValue
    public boolean isNotBefore(@Nonnull DateTime other) {
        return this.toRaw() >= other.toRaw();
    }

    @CheckReturnValue
    public boolean isNotBefore(@Nonnull TimeInterval interval) {
        Optional after = interval.getAfter();
        return !after.isPresent() || this._raw > ((DateTime)after.get()).toRaw();
    }

    @Nonnull
    @CheckReturnValue
    public DateTime midnight() {
        return DateTime.defaultContext().midnight(this);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime nextDay() {
        return DateTime.defaultContext().nextDay(this);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime noon() {
        return DateTime.defaultContext().noon(this);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime notAfter(@Nonnull DateTime limit) {
        return this.isNotAfter(limit) ? this : limit;
    }

    @Nonnull
    @CheckReturnValue
    public DateTime notBefore(@Nonnull DateTime limit) {
        return this.isNotBefore(limit) ? this : limit;
    }

    @Nonnull
    @CheckReturnValue
    public DateTime previousDay() {
        return DateTime.defaultContext().previousDay(this);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime rounded(@Nonnull ElapsedTime whole) {
        return this.rounded(whole.toRaw());
    }

    @Nonnull
    @CheckReturnValue
    public DateTime rounded(long whole) {
        Require.success((whole > 0L ? 1 : 0) != 0);
        if (this._raw < 0L) {
            whole = -whole;
        }
        return DateTime._fromRaw(Math.round((double)this._raw / (double)whole) * whole);
    }

    @Nonnull
    @CheckReturnValue
    public double scaled(@Nonnull ElapsedTime whole) {
        return this.scaled(whole.toRaw());
    }

    @CheckReturnValue
    public double scaled(long whole) {
        return (double)this._raw / (double)whole;
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime sub(@Nonnull DateTime other) {
        return ElapsedTime.fromRaw(this.toRaw() - other.toRaw());
    }

    @Nonnull
    @CheckReturnValue
    public String toBaseString() {
        return DateTime.defaultContext().toBaseString(this);
    }

    @Nonnull
    @CheckReturnValue
    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this._raw >>> 56), (byte)(this._raw >>> 48), (byte)(this._raw >>> 40), (byte)(this._raw >>> 32), (byte)(this._raw >>> 24), (byte)(this._raw >>> 16), (byte)(this._raw >>> 8), (byte)(this._raw >>> 0)};
        return bytes;
    }

    public void toDataOutput(@Nonnull DataOutput destination) throws IOException {
        destination.writeLong(this._raw);
    }

    @Nonnull
    @CheckReturnValue
    public Fields toFields() {
        return DateTime.defaultContext().toFields(this);
    }

    @Nonnull
    @CheckReturnValue
    public String toFileName() {
        String fileName = UTC_CONTEXT._toString(this, true, false, false);
        if (fileName.startsWith("-")) {
            throw new IllegalArgumentException(Message.format(BaseMessages.TIME_VALUE, String.valueOf(this.toRaw())));
        }
        return fileName;
    }

    @Nonnull
    @CheckReturnValue
    public String toFullString() {
        return DateTime.defaultContext().toFullString(this);
    }

    @Nonnull
    @CheckReturnValue
    public String toHexString() {
        return this._raw >= 0L ? "0X" + Long.toHexString(this._raw) : "-0X" + Long.toHexString(-this._raw);
    }

    @Nonnull
    @CheckReturnValue
    public Instant toInstant() {
        long unixRaw = this._raw - 35067168000000000L;
        long secondRaw = ElapsedTime.SECOND.toRaw();
        long nanos = unixRaw % secondRaw * 100L;
        long seconds = unixRaw / secondRaw;
        return Instant.ofEpochSecond(seconds, nanos);
    }

    @CheckReturnValue
    public long toMillis() {
        int hint = (int)(this._raw % 10L);
        long millis = (this._raw - 35067168000000000L) / ElapsedTime.MILLI.toRaw();
        if (hint != 0) {
            millis = millis / 10L * 10L + (long)hint;
        }
        return millis;
    }

    @Nonnull
    @CheckReturnValue
    public String toOrdinalString() {
        return DateTime.defaultContext().toOrdinalString(this);
    }

    @CheckReturnValue
    public long toRaw() {
        return this._raw;
    }

    public String toString() {
        return DateTime.defaultContext().toString(this);
    }

    @Nonnull
    @CheckReturnValue
    public Timestamp toTimestamp() {
        long milliRaw = ElapsedTime.MILLI.toRaw();
        Timestamp timestamp = new Timestamp((this._raw - 35067168000000000L) / milliRaw);
        int nanos = (int)(this._raw % milliRaw * 100L);
        timestamp.setNanos(timestamp.getNanos() + nanos);
        return timestamp;
    }

    @Nonnull
    @CheckReturnValue
    public String toURLString() {
        return DateTime.defaultContext().toURLString(this);
    }

    @CheckReturnValue
    public long toWin32() {
        return this._raw - -81377568000000000L;
    }

    @Nonnull
    @CheckReturnValue
    public ZonedDateTime toZonedDateTime() {
        return DateTime.defaultContext().toZonedDateTime(this);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime valueOf(@Nonnull String timeString) throws IllegalArgumentException {
        return DateTime.defaultContext().fromString(timeString, Optional.of(this));
    }

    private static DateTime _fromRaw(long raw) {
        return new DateTime(Math.min(Math.max(raw, -4611686018427387904L), 0x3FFFFFFFFFFFFFFFL));
    }

    static {
        UTC_CONTEXT = new Context(ZoneOffset.UTC);
        BEGINNING_OF_TIME = new DateTime(-4611686018427387904L);
        END_OF_TIME = new DateTime(0x3FFFFFFFFFFFFFFFL);
        INVALID = new DateTime(Long.MIN_VALUE);
        MJD_EPOCH = new DateTime(0L);
        UNIX_EPOCH = new DateTime(35067168000000000L);
        WINDOWS_EPOCH = new DateTime(-81377568000000000L);
        _defaultContext = _DEFAULT_CONTEXT = new Context();
    }

    public static final class Fields {
        public int day;
        public int hour;
        public int minute;
        public int month;
        public int nano;
        public int second;
        public int year;
    }

    public static class Context {
        private static final int _DEC_BASE = 10;
        private static final Pattern _BASIC_PATTERN = Pattern.compile("([0-9]{4})([0-9]{2})([0-9]{2})(?:(?:T|_|[ ]*+)([0-9]{2})([0-9]{2})(?:([0-9]{2})(?:[.,]?([0-9]{1,7}))?)?(?:(Z)|(?:([-+])([0-9]{2})(?:([0-9]{2}))?))?)?", 2);
        private static final Pattern _EXTENDED_PATTERN = Pattern.compile("(?:(?:(-?[0-9]++)-([0-9]++)(?:-([0-9]++))?)?(?:T|_|[ ]*+)(?:([0-9]{1,2}+)(?::([0-9]{1,2}+)(?::([0-9]{1,2}+)(?:[.,]([0-9]++))?+)?+)?+)?+(?:(Z)|(?:([-+])([0-9]{2})(?::?([0-9]{2}))?))?)", 2);
        private static final int _MAX_NANOS_WIDTH = 7;
        private static final int _MAX_YEAR_WIDTH = 6;
        private static final String _NANOS_ZEROES = "0000000";
        private final ZoneId _zoneId;

        public Context() {
            this(ZoneId.systemDefault());
        }

        public Context(@Nonnull TimeZone timeZone) {
            this(timeZone.toZoneId());
        }

        public Context(@Nonnull ZoneId zoneId) {
            this._zoneId = zoneId;
        }

        @Nonnull
        @CheckReturnValue
        public DateTime fromFields(@Nonnull Fields fields) {
            ZonedDateTime zonedDateTime = ZonedDateTime.of(fields.year, fields.month, fields.day, fields.hour, fields.minute, fields.second, fields.nano, this.getZoneId());
            return DateTime.fromZonedDateTime(zonedDateTime);
        }

        @Nonnull
        @CheckReturnValue
        public DateTime fromString(@Nonnull String timeString) {
            return this.fromString(timeString, Optional.empty());
        }

        @Nonnull
        @CheckReturnValue
        public DateTime fromString(@Nonnull String timeString, @Nonnull Optional<DateTime> reference) throws IllegalArgumentException {
            DateTime dateTime;
            int minus;
            if ((timeString = Require.notEmptyTrimmed((String)timeString)).equalsIgnoreCase(DateTime.BEGINNING_OF_TIME_STRING)) {
                return BEGINNING_OF_TIME;
            }
            if (timeString.equalsIgnoreCase(DateTime.END_OF_TIME_STRING)) {
                return END_OF_TIME;
            }
            int n = minus = timeString.charAt(0) == '-' ? 1 : 0;
            if (timeString.length() > minus + 2 && timeString.charAt(minus) == '0' && (timeString.charAt(minus + 1) == 'X' || timeString.charAt(minus + 1) == 'x')) {
                try {
                    dateTime = DateTime.fromRaw(Long.decode(timeString));
                }
                catch (NumberFormatException exception) {
                    throw new IllegalArgumentException(Message.format(BaseMessages.TIME_RAW_STRING, timeString));
                }
            } else {
                Fields fields;
                Matcher matcher = _EXTENDED_PATTERN.matcher(timeString);
                if (!matcher.matches() && !(matcher = _BASIC_PATTERN.matcher(timeString)).matches()) {
                    throw new IllegalArgumentException(Message.format(BaseMessages.TIME_FORMAT, timeString));
                }
                ZoneId zoneId = this.getZoneId();
                String string = matcher.group(_Pattern.YEAR.group());
                if (string != null) {
                    int year = Integer.parseInt(string);
                    int fieldValue = Integer.parseInt(string);
                    string = matcher.group(_Pattern.MONTH.group());
                    fieldValue = Integer.parseInt(string);
                    string = matcher.group(_Pattern.DAY.group());
                    if (string != null) {
                        fields = new Fields();
                        fields.year = year;
                        if (fieldValue == 0) {
                            ++fieldValue;
                        }
                        fields.month = fieldValue;
                        fieldValue = Integer.parseInt(string);
                        if (fieldValue == 0) {
                            ++fieldValue;
                        }
                        fields.day = fieldValue;
                    } else {
                        if (fieldValue == 0) {
                            ++fieldValue;
                        }
                        fields = this.toFields(DateTime.fromZonedDateTime(ZonedDateTime.of(year, 1, 1, 0, 0, 0, 0, this.getZoneId()).withDayOfYear(fieldValue)));
                    }
                } else if (reference.isPresent()) {
                    fields = this.toFields(reference.get());
                } else {
                    throw new IllegalArgumentException(Message.format(BaseMessages.TIME_YEAR, timeString));
                }
                string = matcher.group(_Pattern.HOUR.group());
                fields.hour = string != null ? Integer.parseInt(string) : 0;
                string = matcher.group(_Pattern.MINUTE.group());
                fields.minute = string != null ? Integer.parseInt(string) : 0;
                string = matcher.group(_Pattern.SECOND.group());
                int n2 = fields.second = string != null ? Integer.parseInt(string) : 0;
                if (matcher.group(_Pattern.ZULU.group()) != null) {
                    zoneId = ZoneOffset.UTC;
                } else {
                    String zoneSign = matcher.group(_Pattern.ZONE_SIGN.group());
                    if (zoneSign != null) {
                        int zoneOffset = Integer.parseInt(matcher.group(_Pattern.ZONE_HOURS.group())) * 60;
                        string = matcher.group(_Pattern.ZONE_MINUTES.group());
                        if (string != null) {
                            zoneOffset += Integer.parseInt(string);
                        }
                        if ("-".equals(zoneSign)) {
                            zoneOffset = -zoneOffset;
                        }
                        zoneId = ZoneOffset.ofTotalSeconds(zoneOffset * 60);
                    }
                }
                string = matcher.group(_Pattern.NANOS.group());
                fields.nano = string != null ? Context.nanosFromString(string) : 0;
                dateTime = DateTime.fromZonedDateTime(ZonedDateTime.of(fields.year, fields.month, fields.day, fields.hour, fields.minute, fields.second, fields.nano, zoneId));
            }
            return dateTime;
        }

        @CheckReturnValue
        public int getDayOfWeek(@Nonnull DateTime dateTime) {
            return this.toZonedDateTime(dateTime).getDayOfWeek().getValue() % 7;
        }

        @CheckReturnValue
        public int getDaysInMonth(@Nonnull DateTime dateTime) {
            return this.toZonedDateTime(dateTime).toLocalDate().lengthOfMonth();
        }

        @Nonnull
        @CheckReturnValue
        public TimeZone getTimeZone() {
            return TimeZone.getTimeZone(this.getZoneId());
        }

        @Nonnull
        @CheckReturnValue
        public ZoneId getZoneId() {
            return this._zoneId;
        }

        @Nonnull
        @CheckReturnValue
        public DateTime midnight(@Nonnull DateTime dateTime) {
            Fields fields = this.toFields(dateTime);
            fields.hour = 0;
            fields.minute = 0;
            fields.second = 0;
            fields.nano = 0;
            return this.fromFields(fields);
        }

        @Nonnull
        @CheckReturnValue
        public DateTime nextDay(@Nonnull DateTime dateTime) {
            ZonedDateTime zonedDateTime = this.midnight(dateTime).toZonedDateTime();
            return DateTime.fromZonedDateTime(zonedDateTime.plusDays(1L));
        }

        @Nonnull
        @CheckReturnValue
        public DateTime noon(@Nonnull DateTime dateTime) {
            ZonedDateTime zonedDateTime = this.midnight(dateTime).toZonedDateTime();
            return DateTime.fromZonedDateTime(zonedDateTime.withHour(12));
        }

        @Nonnull
        @CheckReturnValue
        public DateTime previousDay(@Nonnull DateTime dateTime) {
            ZonedDateTime zonedDateTime = this.midnight(dateTime).toZonedDateTime();
            return DateTime.fromZonedDateTime(zonedDateTime.minusDays(1L));
        }

        @Nonnull
        @CheckReturnValue
        public String toBaseString(@Nonnull DateTime dateTime) {
            return this._toString(dateTime, false, false, false);
        }

        @Nonnull
        @CheckReturnValue
        public Fields toFields(@Nonnull DateTime dateTime) {
            Fields fields = new Fields();
            ZonedDateTime zonedDateTime = this.toZonedDateTime(dateTime);
            fields.year = zonedDateTime.getYear();
            fields.month = zonedDateTime.getMonthValue();
            fields.day = zonedDateTime.getDayOfMonth();
            fields.hour = zonedDateTime.getHour();
            fields.minute = zonedDateTime.getMinute();
            fields.second = zonedDateTime.getSecond();
            fields.nano = zonedDateTime.getNano();
            return fields;
        }

        @Nonnull
        @CheckReturnValue
        public String toFullString(@Nonnull DateTime dateTime) {
            return this._toString(dateTime, true, true, false);
        }

        @Nonnull
        @CheckReturnValue
        public String toOrdinalString(@Nonnull DateTime dateTime) {
            return this._toString(dateTime, false, true, true);
        }

        public String toString() {
            return "(" + this.getZoneId() + ")";
        }

        @Nonnull
        @CheckReturnValue
        public String toString(@Nonnull DateTime dateTime) {
            return this._toString(dateTime, false, true, false);
        }

        @Nonnull
        @CheckReturnValue
        public String toURLString(@Nonnull DateTime dateTime) {
            try {
                return URLEncoder.encode(this.toString(dateTime), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException exception) {
                throw new RuntimeException(exception);
            }
        }

        @Nonnull
        @CheckReturnValue
        public ZonedDateTime toZonedDateTime(@Nonnull DateTime dateTime) {
            return ZonedDateTime.ofInstant(dateTime.toInstant(), this.getZoneId());
        }

        @Nonnull
        @CheckReturnValue
        static char[] formatNumber(int number, int width) {
            char[] chars = new char[width];
            for (int i = width - 1; i >= 0; --i) {
                if (number > 0) {
                    if (number >= 10) {
                        chars[i] = (char)(48 + number % 10);
                        number /= 10;
                        continue;
                    }
                    chars[i] = (char)(48 + number);
                    number = 0;
                    continue;
                }
                chars[i] = 48;
            }
            return chars;
        }

        @CheckReturnValue
        static int nanosFromString(@Nonnull String nanosString) {
            return Integer.parseInt(nanosString + _NANOS_ZEROES.substring(0, 7 - Math.min(nanosString.length(), 7))) * 100;
        }

        @Nonnull
        @CheckReturnValue
        static String nanosToString(int nanos) {
            int index;
            char[] chars = Context.formatNumber(nanos / 100, 7);
            for (index = 7; index > 1 && chars[index - 1] == '0'; --index) {
            }
            return new String(chars, 0, index);
        }

        @Nonnull
        @CheckReturnValue
        String _toString(@Nonnull DateTime dateTime, boolean full, boolean extended, boolean ordinal) {
            int index;
            if (dateTime.isBeginningOfTime()) {
                return DateTime.BEGINNING_OF_TIME_STRING;
            }
            if (dateTime.isEndOfTime()) {
                return DateTime.END_OF_TIME_STRING;
            }
            StringBuilder stringBuilder = new StringBuilder();
            ZonedDateTime zonedDateTime = this.toZonedDateTime(dateTime);
            int year = zonedDateTime.getYear();
            int second = zonedDateTime.getSecond();
            int nanos = zonedDateTime.getNano();
            int offset = zonedDateTime.getOffset().getTotalSeconds() * 1000;
            char[] chars = Context.formatNumber(year < 0 ? -year : year, 6);
            int n = index = chars[1] == '0' ? 2 : 1;
            if (year < 0) {
                chars[--index] = 45;
            }
            stringBuilder.append(chars, index, 6 - index);
            if (extended) {
                stringBuilder.append('-');
            }
            if (ordinal) {
                stringBuilder.append(Context.formatNumber(zonedDateTime.getDayOfYear(), 3));
            } else {
                stringBuilder.append(Context.formatNumber(zonedDateTime.getMonthValue(), 2));
                if (extended) {
                    stringBuilder.append('-');
                }
                stringBuilder.append(Context.formatNumber(zonedDateTime.getDayOfMonth(), 2));
            }
            stringBuilder.append('T');
            stringBuilder.append(Context.formatNumber(zonedDateTime.getHour(), 2));
            if (extended) {
                stringBuilder.append(':');
            }
            stringBuilder.append(Context.formatNumber(zonedDateTime.getMinute(), 2));
            if (full || second > 0 || nanos > 0) {
                if (extended) {
                    stringBuilder.append(':');
                }
                stringBuilder.append(Context.formatNumber(second, 2));
                if (full || nanos > 0) {
                    if (extended) {
                        stringBuilder.append('.');
                    }
                    if (full) {
                        stringBuilder.append(Context.formatNumber(nanos / 100, 7));
                    } else {
                        stringBuilder.append(Context.nanosToString(nanos));
                    }
                }
            }
            if (full && extended || offset != 0) {
                if (offset > 0) {
                    stringBuilder.append('+');
                } else {
                    stringBuilder.append('-');
                    offset = -offset;
                }
                stringBuilder.append(Context.formatNumber((offset /= 60000) / 60, 2));
                if (full || !extended || (offset %= 60) > 0) {
                    if (extended) {
                        stringBuilder.append(':');
                    }
                    stringBuilder.append(Context.formatNumber(offset, 2));
                }
            } else {
                stringBuilder.append('Z');
            }
            return stringBuilder.toString();
        }

        private static enum _Pattern {
            YEAR,
            MONTH,
            DAY,
            HOUR,
            MINUTE,
            SECOND,
            NANOS,
            ZULU,
            ZONE_SIGN,
            ZONE_HOURS,
            ZONE_MINUTES;


            int group() {
                return this.ordinal() + 1;
            }
        }
    }
}

