/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Inet;

@Immutable
public final class UUID
implements Serializable,
Comparable<UUID> {
    public static final int BYTES_LENGTH = 16;
    public static final String MAC_ADDRESS_PROPERTY = "rvpf.uuid.mac";
    public static final int NAME_LENGTH = 25;
    public static final UUID NULL;
    public static final int RAW_STRING_LENGTH;
    public static final int STRING_LENGTH;
    static final byte MULTICAST_BIT_MASK = 1;
    static final int VARIANT_4122 = 128;
    static final int VERSION_4 = 64;
    private static final int _BYTE_MASK = 255;
    private static final int _DELETED_MASK = 128;
    private static final int _HEX_BASE = 16;
    private static final int _NAME_BASE = 36;
    private static final Optional<byte[]> _NODE;
    private static final int _NODE_OFFSET = 10;
    private static final Pattern _RAW_UUID_PATTERN;
    private static final Pattern _UUID_PATTERN;
    private static final int _VARIANT_OFFSET = 8;
    private static final SecureRandom _RANDOM;
    private static final long serialVersionUID = 1L;
    private final byte[] _bytes;

    private UUID(@Nonnull byte[] bytes) {
        this._bytes = bytes;
    }

    @Nonnull
    @CheckReturnValue
    public static UUID fromBytes(@Nonnull byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException(Message.format(BaseMessages.UUID_BYTES_LENGTH, String.valueOf(bytes.length)));
        }
        return new UUID((byte[])bytes.clone());
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<UUID> fromDataInput(@Nonnull DataInput source) throws IOException {
        Optional<UUID> uuid;
        byte length = source.readByte();
        if (length > 0) {
            byte[] bytes = new byte[length];
            source.readFully(bytes);
            uuid = Optional.of(UUID.fromBytes(bytes));
        } else {
            uuid = Optional.empty();
        }
        return uuid;
    }

    @Nonnull
    @CheckReturnValue
    public static UUID fromLongs(long high, long low) {
        int i;
        byte[] bytes = new byte[16];
        for (i = 7; i >= 0; --i) {
            bytes[i] = (byte)high;
            high >>= 8;
        }
        for (i = 15; i >= 8; --i) {
            bytes[i] = (byte)low;
            low >>= 8;
        }
        return new UUID(bytes);
    }

    @Nonnull
    @CheckReturnValue
    public static UUID fromName(@Nonnull String name) {
        byte[] buffer;
        byte[] bytes = new byte[16];
        name = name.trim();
        try {
            buffer = new BigInteger(name, 36).toByteArray();
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException(Message.format(BaseMessages.UUID_NAME_BAD, name));
        }
        if (buffer.length != 17 || buffer[0] != 1) {
            throw new IllegalArgumentException(Message.format(BaseMessages.UUID_NAME_LENGTH, "UUID name '", name));
        }
        System.arraycopy(buffer, 1, bytes, 0, bytes.length);
        return new UUID(bytes);
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<UUID> fromString(@Nonnull String string) {
        if ((string = string.trim()).isEmpty()) {
            return Optional.empty();
        }
        byte[] bytes = UUID._toBytes(string);
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException(Message.format(BaseMessages.UUID_STRING_INVALID, string));
        }
        return Optional.of(new UUID(bytes));
    }

    @Nonnull
    @CheckReturnValue
    public static UUID generate() {
        return UUID.generate(Optional.empty());
    }

    @Nonnull
    @CheckReturnValue
    public static UUID generate(@Nonnull Optional<byte[]> seed) {
        if (seed.isPresent() && seed.get().length >= 16) {
            return UUID.fromBytes(seed.get());
        }
        byte[] bytes = UUID._generateBytes();
        if (seed.isPresent()) {
            System.arraycopy(seed.get(), 0, bytes, 0, seed.get().length);
        }
        return new UUID(bytes);
    }

    @Nonnull
    @CheckReturnValue
    public static UUID generate(@Nonnull String seed) {
        if (seed == null) {
            return UUID.generate(Optional.empty());
        }
        if ((seed = seed.trim()).isEmpty()) {
            return UUID.generate(Optional.empty());
        }
        byte[] bytes = UUID._toBytes(seed);
        if (bytes == null) {
            throw new IllegalArgumentException(Message.format(BaseMessages.UUID_SEED_INVALID, seed));
        }
        return UUID.generate(Optional.of(bytes));
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<byte[]> getNode() {
        return _NODE;
    }

    @CheckReturnValue
    public static boolean isUUID(@Nonnull String key) {
        int length = (key = key.trim()).length();
        if (length == RAW_STRING_LENGTH) {
            return _RAW_UUID_PATTERN.matcher(key).matches();
        }
        if (length == STRING_LENGTH) {
            return _UUID_PATTERN.matcher(key).matches();
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<UUID> readExternal(@Nonnull ObjectInput source) throws IOException {
        return UUID.fromDataInput(source);
    }

    @Nonnull
    @CheckReturnValue
    public static UUID synthesize(long high, int midHigh, int midLow, long low) {
        int i;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(16);
        byte[] time = new byte[8];
        byte[] seq = new byte[2];
        byte[] node = new byte[6];
        time[0] = 64;
        time[1] = (byte)midHigh;
        for (i = time.length - 1; i > 1; --i) {
            time[i] = (byte)high;
            high >>= 8;
        }
        stream.write(time, 2, 6);
        stream.write(time, 0, 2);
        seq[0] = -128;
        seq[1] = (byte)midLow;
        stream.write(seq, 0, 2);
        node[0] = 1;
        for (i = node.length - 1; i > 0; --i) {
            node[i] = (byte)low;
            low >>= 8;
        }
        stream.write(node, 0, 6);
        return new UUID(stream.toByteArray());
    }

    public static void writeExternal(@Nonnull Optional<UUID> uuid, @Nonnull ObjectOutput destination) throws IOException {
        if (uuid.isPresent()) {
            uuid.get().toDataOutput(destination);
        } else {
            destination.writeByte(0);
        }
    }

    @Override
    public int compareTo(UUID other) {
        int comparison = 0;
        for (int i = 0; i < 16 && (comparison = (this._bytes[i] & 0xFF) - (other._bytes[i] & 0xFF)) == 0; ++i) {
        }
        return comparison;
    }

    @Nonnull
    @CheckReturnValue
    public UUID deleted() {
        UUID deleted;
        if (this.isDeleted()) {
            deleted = this;
        } else {
            byte[] bytes = (byte[])this._bytes.clone();
            bytes[8] = (byte)(bytes[8] & 0x7F);
            deleted = new UUID(bytes);
        }
        return deleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UUID) {
            return Arrays.equals(this._bytes, ((UUID)other)._bytes);
        }
        return false;
    }

    @CheckReturnValue
    public long getHigh() {
        long high = 0L;
        for (int i = 0; i < 6; ++i) {
            high <<= 8;
            high |= (long)(this._bytes[i] & 0xFF);
        }
        return high;
    }

    @CheckReturnValue
    public long getLeastSignificantBits() {
        return this._toLong(8);
    }

    @CheckReturnValue
    public long getLow() {
        long low = 0L;
        for (int i = 11; i < 16; ++i) {
            low <<= 8;
            low |= (long)(this._bytes[i] & 0xFF);
        }
        return low;
    }

    @CheckReturnValue
    public int getMidHigh() {
        return this._bytes[7] & 0xFF;
    }

    @CheckReturnValue
    public int getMidLow() {
        return this._bytes[9] & 0xFF;
    }

    @CheckReturnValue
    public long getMostSignificantBits() {
        return this._toLong(0);
    }

    public int hashCode() {
        return Arrays.hashCode(this._bytes);
    }

    @CheckReturnValue
    public boolean isDeleted() {
        return (this._bytes[8] & 0x80) == 0;
    }

    @CheckReturnValue
    public boolean isRandomNode() {
        return (this._bytes[10] & 1) != 0;
    }

    @Nonnull
    @CheckReturnValue
    public byte[] toBytes() {
        return (byte[])this._bytes.clone();
    }

    public void toDataOutput(@Nonnull DataOutput destination) throws IOException {
        destination.writeByte(16);
        destination.write(this._bytes);
    }

    @Nonnull
    @CheckReturnValue
    public String toName() {
        byte[] buffer = new byte[17];
        buffer[0] = 1;
        System.arraycopy(this._bytes, 0, buffer, 1, 16);
        return new BigInteger(buffer).toString(36);
    }

    @Nonnull
    @CheckReturnValue
    public String toRawString() {
        return this._toHex(0, 16);
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("-");
        stringJoiner.add(this._toHex(0, 4));
        stringJoiner.add(this._toHex(4, 2));
        stringJoiner.add(this._toHex(6, 2));
        stringJoiner.add(this._toHex(8, 2));
        stringJoiner.add(this._toHex(10, 6));
        return stringJoiner.toString();
    }

    @Nonnull
    @CheckReturnValue
    public String toURN() {
        return "urn:uuid:" + this.toString();
    }

    @Nonnull
    @CheckReturnValue
    public UUID undeleted() {
        UUID undeleted;
        if (this.isDeleted()) {
            byte[] bytes = (byte[])this._bytes.clone();
            bytes[8] = (byte)(bytes[8] | 0xFFFFFF80);
            undeleted = new UUID(bytes);
        } else {
            undeleted = this;
        }
        return undeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] _generateBytes() {
        byte[] node;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(16);
        byte[] time = new byte[8];
        byte[] seq = new byte[2];
        SecureRandom secureRandom = _RANDOM;
        synchronized (secureRandom) {
            _RANDOM.nextBytes(time);
            time[0] = (byte)(time[0] & 0xF);
            time[0] = (byte)(time[0] | 0x40);
            _RANDOM.nextBytes(seq);
            seq[0] = (byte)(seq[0] & 0x3F);
            seq[0] = (byte)(seq[0] | 0xFFFFFF80);
            if (_NODE.isPresent()) {
                node = _NODE.get();
            } else {
                node = new byte[6];
                _RANDOM.nextBytes(node);
                node[0] = (byte)(node[0] | 1);
            }
        }
        stream.write(time, 4, 4);
        stream.write(time, 2, 2);
        stream.write(time, 0, 2);
        stream.write(seq, 0, 2);
        stream.write(node, 0, 6);
        return stream.toByteArray();
    }

    private static byte[] _toBytes(String string) {
        ByteArrayOutputStream stream;
        try {
            int length = string.length();
            int i = 0;
            stream = new ByteArrayOutputStream(16);
            while (i < length) {
                if (string.charAt(i) == '-') {
                    ++i;
                    continue;
                }
                stream.write(Integer.parseInt(string.substring(i, i + 2), 16));
                i += 2;
            }
        }
        catch (NumberFormatException exception) {
            return null;
        }
        catch (IndexOutOfBoundsException exception) {
            return null;
        }
        return stream.toByteArray();
    }

    private String _toHex(int start, int length) {
        StringBuilder stringBuilder = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            String hexDigits = Integer.toHexString(this._bytes[start + i] & 0xFF);
            if (hexDigits.length() < 2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(hexDigits);
        }
        return stringBuilder.toString();
    }

    private long _toLong(int start) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(this._bytes[start + i] & 0xFF);
        }
        return result;
    }

    static {
        _RANDOM = new SecureRandom();
        NULL = new UUID(new byte[16]);
        RAW_STRING_LENGTH = 32;
        STRING_LENGTH = RAW_STRING_LENGTH + 4;
        String macInterface = System.getProperty(MAC_ADDRESS_PROPERTY);
        Optional node = Optional.empty();
        if (macInterface != null && (node = Inet.getHardwareAddress((String)macInterface.trim())).isPresent() && ((byte[])node.get()).length != 6) {
            node = Optional.empty();
        }
        _NODE = node;
        _RAW_UUID_PATTERN = Pattern.compile("[0-9A-F]{32}", 2);
        _UUID_PATTERN = Pattern.compile("[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}", 2);
    }
}

