/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger;

import java.text.MessageFormat;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.logger.log4j.AbstractMessage;
import org.rvpf.base.tool.Require;

@ThreadSafe
public final class Message
extends AbstractMessage {
    private static final long serialVersionUID = 1L;
    private final Throwable _cause;
    private final Messages.Entry _entry;
    private MessageFormat _format;
    private final Object[] _params;
    private final String _pattern;

    public Message(@Nonnull Messages.Entry entry, Object ... params) {
        this(null, null, (Messages.Entry)Require.notNull((Object)entry), params);
    }

    public Message(@Nonnull String format, Object ... params) {
        this(null, (String)Require.notNull((Object)format), null, params);
    }

    public Message(@Nonnull Throwable cause, @Nonnull Messages.Entry entry, Object ... params) {
        this((Throwable)Require.notNull((Object)cause), null, (Messages.Entry)Require.notNull((Object)entry), params);
    }

    public Message(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this((Throwable)Require.notNull((Object)cause), (String)Require.notNull((Object)format), null, params);
    }

    private Message(Throwable cause, String format, Messages.Entry entry, Object ... params) {
        this._cause = cause;
        this._pattern = format;
        this._entry = entry;
        this._params = params;
    }

    @Nonnull
    @CheckReturnValue
    public static String format(@Nonnull Messages.Entry entry, Object ... params) {
        return Message.format(entry.toString(), params);
    }

    @Nonnull
    @CheckReturnValue
    public static String format(@Nonnull String format, Object ... params) {
        return params.length > 0 ? MessageFormat.format(format, params) : format;
    }

    @Nonnull
    @CheckReturnValue
    public static String mark(@Nonnull String format, Object ... params) {
        return Message.format(format, params);
    }

    @Nonnull
    @CheckReturnValue
    public synchronized String format(Object ... params) {
        if (this._format == null) {
            String pattern;
            String string = pattern = this._pattern != null ? this._pattern : this._entry.toString();
            if (params.length == 0) {
                return pattern;
            }
            this._format = new MessageFormat(pattern);
        }
        return this._format.format(params);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this._cause);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Messages.Entry> getEntry() {
        return Optional.ofNullable(this._entry);
    }

    @Nonnull
    @CheckReturnValue
    public Object[] getParams() {
        return this._params;
    }

    public String toString() {
        return this.format(this._params);
    }
}

