/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;

@Immutable
public final class Messages {
    private static final Map<Class<?>, ResourceBundle> _BUNDLES = new ConcurrentHashMap();
    private static final String _KEY_NOT_FOUND = "Message key ''{0}'' not found in ''{1}''";
    private static final Logger _LOGGER = Logger.getInstance(Messages.class);
    private static final String _UNKNOWN_BUNDLE = "Failed to locate a messages bundle: {0}";
    private static final ResourceBundle _EMPTY_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public String nextElement() {
                    return null;
                }
            };
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }
    };

    private Messages() {
    }

    @Nonnull
    @CheckReturnValue
    public static String getString(Entry entry) {
        String string;
        ResourceBundle bundle = _BUNDLES.get(entry.getClass());
        if (bundle == null) {
            bundle = Messages._getBundle(entry);
            _BUNDLES.put(entry.getClass(), bundle);
        }
        try {
            string = (String)bundle.getObject(entry.name());
        }
        catch (MissingResourceException exception) {
            if (entry.getClass() != BaseMessages.class) {
                Logger.getInstance(entry.getClass()).warn(BaseMessages.MESSAGE_KEY_NOT_FOUND, entry.name(), entry.getBundleName());
            } else {
                Logger.getInstance(entry.getClass()).log(Logger.LogLevel.WARN, _KEY_NOT_FOUND, entry.name(), entry.getBundleName());
            }
            string = entry.name();
        }
        return string;
    }

    private static ResourceBundle _getBundle(Entry entry) {
        ResourceBundle bundle;
        String bundleName = entry.getBundleName();
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException exception) {
            bundle = null;
        }
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), Messages.class.getClassLoader());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (entry.getClass() != BaseMessages.class) {
            if (bundle != null) {
                _LOGGER.debug(BaseMessages.LOADED_MESSAGES, bundleName);
            } else {
                _LOGGER.warn(BaseMessages.UNKNOWN_BUNDLE, bundleName);
                bundle = _EMPTY_BUNDLE;
            }
        } else if (bundle == null) {
            _LOGGER.log(Logger.LogLevel.WARN, _UNKNOWN_BUNDLE, bundleName);
            bundle = _EMPTY_BUNDLE;
        }
        return bundle;
    }

    public static interface Entry {
        @Nonnull
        @CheckReturnValue
        public String getBundleName();

        @Nonnull
        @CheckReturnValue
        public String name();
    }
}

