/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger.log4j;

import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.logger.Logger;

@Plugin(name="Alerts", category="Core", elementType="appender", printObject=true)
public final class AlertsAppender
extends AbstractAppender {
    private final _AlertsSender _sender = new _AlertsSender();

    private AlertsAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    @PluginFactory
    public static AlertsAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") String ignoreExceptions) {
        if (name == null) {
            LOGGER.error("No name provided for MailAppender");
            return null;
        }
        boolean ignore = Booleans.parseBoolean((String)ignoreExceptions, (boolean)true);
        return new AlertsAppender(name, filter, layout, ignore);
    }

    public void append(LogEvent event) {
        this._sender.send(event);
    }

    public void start() {
        this._sender.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this._sender.close();
    }

    private static final class _ThreadEvent {
        private final LogEvent _event;
        private final Thread _thread = Thread.currentThread();

        _ThreadEvent(LogEvent event) {
            this._event = event;
        }

        LogEvent getEvent() {
            return this._event;
        }

        Thread getThread() {
            return this._thread;
        }
    }

    private static final class _AlertsSender
    implements Runnable {
        private String _logID;
        private final BlockingQueue<_ThreadEvent> _queue = new LinkedBlockingQueue<_ThreadEvent>();
        private Thread _thread;

        _AlertsSender() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Logger.setLogID(Optional.ofNullable(this._logID));
            block4: while (true) {
                try {
                    while (true) {
                        _ThreadEvent threadEvent;
                        ClassLoader classLoader;
                        if (!((classLoader = (threadEvent = this._queue.take()).getThread().getContextClassLoader()) instanceof Alert.Dispatcher)) {
                            continue;
                        }
                        LogEvent event = threadEvent.getEvent();
                        Object id = event.getContextData().getValue("ID");
                        String alertName = (id != null ? id.toString() : "") + ':' + event.getLoggerName();
                        String alertInfo = event.getMessage().getFormattedMessage();
                        Level level = event.getLevel();
                        Logger.LogLevel alertLevel = level.isMoreSpecificThan(Level.FATAL) ? Logger.LogLevel.FATAL : (level.isMoreSpecificThan(Level.ERROR) ? Logger.LogLevel.ERROR : (level.isMoreSpecificThan(Level.WARN) ? Logger.LogLevel.WARN : Logger.LogLevel.INFO));
                        try {
                            ((Alert.Dispatcher)classLoader).dispatchAlert(alertLevel, alertName, alertInfo);
                            continue block4;
                        }
                        catch (RuntimeException exception) {
                            if (!(exception.getCause() instanceof NoSuchObjectException)) throw exception;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException exception) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        void close() {
            Thread currentThread = Thread.currentThread();
            int priority = currentThread.getPriority();
            currentThread.setPriority(2);
            Thread.yield();
            currentThread.setPriority(priority);
            if (this._thread != null) {
                this._thread.interrupt();
            }
        }

        void send(LogEvent event) {
            this._queue.add(new _ThreadEvent(event));
        }

        void start() {
            this._thread = new Thread((Runnable)this, "Alerts sender");
            this._logID = Logger.currentLogID().orElse(null);
            this._thread.start();
        }
    }
}

