/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger.log4j;

import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.OptionConverter;
import org.rvpf.base.logger.log4j.DetailFileManager;

@Plugin(name="DetailFile", category="Core", elementType="appender", printObject=true)
public final class DetailFileAppender
extends AbstractOutputStreamAppender<DetailFileManager> {
    public static final String LOG_BACKUPS_PROPERTY = "rvpf.log.backups";
    public static final String LOG_PREFIX_PROPERTY = "rvpf.log.prefix";
    public static final String LOG_SIZE_PROPERTY = "rvpf.log.size";
    private static final int _DEFAULT_BUFFER_SIZE = 8192;

    private DetailFileAppender(String name, Filter filter, boolean immediateFlush, Layout<? extends Serializable> layout, boolean ignoreExceptions, DetailFileManager manager) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, (OutputStreamManager)manager);
    }

    @PluginFactory
    public static DetailFileAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="directory", defaultString=".") String directory, @PluginAttribute(value="fileNamePrefix") String fileNamePrefix, @PluginAttribute(value="fileNameSuffix", defaultString=".log") String fileNameSuffix, @PluginAttribute(value="maxFileSize", defaultString="0") String maxFileSize, @PluginAttribute(value="maxBackups", defaultInt=1) int maxBackups, @PluginAttribute(value="locking", defaultBoolean=false) boolean locking, @PluginAttribute(value="immediateFlush", defaultBoolean=true) boolean immediateFlush, @PluginAttribute(value="bufferedIo", defaultBoolean=true) boolean bufferedIo, @PluginAttribute(value="bufferSize", defaultInt=8192) int bufferSize, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions) {
        DetailFileManager manager;
        String property;
        if (name == null) {
            LOGGER.error("No name provided for DetailFileAppender");
            return null;
        }
        if (locking && bufferedIo) {
            LOGGER.warn("Locking and buffering are mutually exclusive: buffering is disabled");
            bufferedIo = false;
        }
        if (!bufferedIo) {
            bufferSize = -1;
        }
        if ((property = System.getProperty(LOG_PREFIX_PROPERTY)) != null) {
            fileNamePrefix = property;
        }
        if ((property = System.getProperty(LOG_SIZE_PROPERTY)) != null) {
            maxFileSize = property;
        }
        if ((property = System.getProperty(LOG_BACKUPS_PROPERTY)) != null) {
            maxBackups = Integer.parseInt(property);
        }
        if ((manager = DetailFileManager.getFileManager(directory, fileNamePrefix != null ? fileNamePrefix : "", maxBackups, fileNameSuffix, OptionConverter.toFileSize((String)maxFileSize, (long)0L), locking, bufferSize, layout)) == null) {
            return null;
        }
        return new DetailFileAppender(name, filter, immediateFlush, layout, ignoreExceptions, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        DetailFileManager manager;
        DetailFileManager detailFileManager = manager = (DetailFileManager)this.getManager();
        synchronized (detailFileManager) {
            if (manager.checkRollover()) {
                super.append(event);
            }
        }
    }
}

