/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger.log4j;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.util.Constants;
import org.rvpf.base.tool.Require;

public class DetailFileManager
extends FileManager {
    private static final _DetailFileManagerFactory _FACTORY = new _DetailFileManagerFactory();
    private long _fileSize;
    private final _LogFiles _logFiles;
    private final long _maxFileSize;

    protected DetailFileManager(String fileName, OutputStream outputStream, _LogFiles logFiles, long maxFileSize, boolean locking, int bufferSize, Layout<? extends Serializable> layout) {
        super(null, fileName, outputStream, false, locking, false, null, layout, layout != null, ByteBuffer.wrap(new byte[bufferSize > 0 ? bufferSize : Constants.ENCODER_BYTE_BUFFER_SIZE]));
        this._logFiles = logFiles;
        this._maxFileSize = maxFileSize;
    }

    public static DetailFileManager getFileManager(String directory, String fileNamePrefix, int maxBackups, String fileNameSuffix, long maxFileSize, boolean locking, int bufferSize, Layout<? extends Serializable> layout) {
        return (DetailFileManager)DetailFileManager.getManager((String)(directory + fileNamePrefix + maxBackups + fileNameSuffix), (Object)new _FactoryData(directory, fileNamePrefix, maxBackups, fileNameSuffix, maxFileSize, locking, bufferSize, layout), (ManagerFactory)_FACTORY);
    }

    @CheckReturnValue
    public boolean checkRollover() {
        if (this.getOutputStream() == null) {
            return false;
        }
        if (this._fileSize > this._maxFileSize) {
            this.close();
            OutputStream outputStream = DetailFileManager._makeOutputStream(this._logFiles.newLogFile(), this.getBufferSize());
            this.setOutputStream(outputStream);
            if (outputStream == null) {
                return false;
            }
            this._fileSize = 0L;
        }
        return true;
    }

    protected OutputStream getOutputStream() {
        try {
            return super.getOutputStream();
        }
        catch (IOException exception) {
            throw new AppenderLoggingException((Throwable)exception);
        }
    }

    protected synchronized void write(byte[] bytes, int offset, int length) {
        this._fileSize += (long)length;
        super.write(bytes, offset, length);
    }

    static Logger _getLogger() {
        return LOGGER;
    }

    static OutputStream _makeOutputStream(File outputFile, int bufferSize) {
        OutputStream outputStream;
        try {
            outputStream = new FileOutputStream(outputFile, false);
        }
        catch (FileNotFoundException exception) {
            LOGGER.error("Failed to open log file '" + outputFile + "': " + exception);
            return null;
        }
        if (bufferSize > 0) {
            outputStream = new BufferedOutputStream(outputStream, bufferSize);
        }
        return outputStream;
    }

    private static class _LogFiles
    implements FileFilter {
        private final String _directory;
        private final Pattern _fileNamePattern;
        private final String _fileNamePrefix;
        private final String _fileNameSuffix;
        private final LinkedList<File> _logFiles = new LinkedList();
        private final int _maxBackups;
        private final int _maxSequence;
        private final int _sequenceLength;

        _LogFiles(String directory, String fileNamePrefix, int maxBackups, String fileNameSuffix) {
            this._directory = directory;
            this._fileNamePrefix = fileNamePrefix;
            this._maxBackups = maxBackups;
            this._fileNameSuffix = fileNameSuffix;
            this._sequenceLength = 1 + (int)Math.log10(3 * this._maxBackups);
            this._maxSequence = 10 * this._sequenceLength - 1;
            this._fileNamePattern = Pattern.compile(Pattern.quote(this._fileNamePrefix) + "-([0-9]{" + this._sequenceLength + "})" + Pattern.quote(this._fileNameSuffix), 2);
        }

        @Override
        public boolean accept(File file) {
            return this._fileNamePattern.matcher(file.getName()).matches();
        }

        File newLogFile() {
            int sequence;
            while (this._logFiles.size() > this._maxBackups) {
                File oldestFile = this._logFiles.removeFirst();
                if (oldestFile.delete()) continue;
                DetailFileManager._getLogger().warn("Failed to delete old log file '" + oldestFile.getAbsolutePath() + "'");
            }
            if (this._logFiles.isEmpty()) {
                sequence = 0;
            } else {
                File newestFile = this._logFiles.getLast();
                Matcher matcher = this._fileNamePattern.matcher(newestFile.getName());
                matcher.matches();
                sequence = Integer.parseInt(matcher.group(1));
            }
            if (++sequence > this._maxSequence) {
                sequence = 1;
            }
            File newLogFile = new File(this._directory, String.format((Locale)null, "%s-%0" + this._sequenceLength + "d%s", this._fileNamePrefix, sequence, this._fileNameSuffix));
            this._logFiles.addLast(newLogFile);
            return newLogFile;
        }

        void scan() {
            File directoryFile = new File(this._directory);
            File[] directoryFiles = (File[])Require.notNull((Object)directoryFile.listFiles(this));
            this._logFiles.clear();
            if (directoryFiles.length < 1) {
                return;
            }
            final class _FileCreationTime
            implements Comparable<_FileCreationTime> {
                private final FileTime _creationTime;
                private final File _file;

                _FileCreationTime(File file, FileTime creationTime) {
                    this._file = file;
                    this._creationTime = creationTime;
                }

                @Override
                public int compareTo(_FileCreationTime other) {
                    return this._creationTime.compareTo(other._creationTime);
                }

                public boolean equals(Object other) {
                    throw new UnsupportedOperationException();
                }

                public int hashCode() {
                    throw new UnsupportedOperationException();
                }

                File getFile() {
                    return this._file;
                }
            }
            Object[] fileCreationTimes = new _FileCreationTime[directoryFiles.length];
            for (int i = 0; i < fileCreationTimes.length; ++i) {
                File file = directoryFiles[i];
                try {
                    fileCreationTimes[i] = new _FileCreationTime(file, (FileTime)Files.getAttribute(file.toPath(), "creationTime", new LinkOption[0]));
                    continue;
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
            Arrays.sort(fileCreationTimes);
            for (Object fileCreationTime : fileCreationTimes) {
                this._logFiles.add(((_FileCreationTime)fileCreationTime).getFile());
            }
        }
    }

    private static class _FactoryData {
        final int bufferSize;
        final String directory;
        final String fileNamePrefix;
        final String fileNameSuffix;
        final Layout<? extends Serializable> layout;
        final boolean locking;
        final int maxBackups;
        final long maxFileSize;

        _FactoryData(String directory, String fileNamePrefix, int maxBackups, String fileNameSuffix, long maxFileSize, boolean locking, int bufferSize, Layout<? extends Serializable> layout) {
            this.directory = directory;
            this.fileNamePrefix = fileNamePrefix;
            this.maxBackups = maxBackups;
            this.fileNameSuffix = fileNameSuffix;
            this.maxFileSize = maxFileSize;
            this.locking = locking;
            this.bufferSize = bufferSize;
            this.layout = layout;
        }
    }

    private static class _DetailFileManagerFactory
    implements ManagerFactory<FileManager, _FactoryData> {
        _DetailFileManagerFactory() {
        }

        public DetailFileManager createManager(String name, _FactoryData data) {
            File directoryFile = new File(data.directory);
            if (!directoryFile.mkdirs() && !directoryFile.isDirectory()) {
                DetailFileManager._getLogger().error("Failed to create log directory '" + directoryFile.getAbsolutePath() + "'");
                return null;
            }
            _LogFiles logFiles = new _LogFiles(data.directory, data.fileNamePrefix, data.maxBackups, data.fileNameSuffix);
            logFiles.scan();
            OutputStream outputStream = DetailFileManager._makeOutputStream(logFiles.newLogFile(), data.bufferSize);
            if (outputStream == null) {
                return null;
            }
            return new DetailFileManager(name, outputStream, logFiles, data.maxFileSize, data.locking, data.bufferSize, data.layout);
        }
    }
}

