/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger.log4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.log4j.TriggeringPolicy;

@Plugin(name="MidnightTriggeringPolicy", category="Core", printObject=true)
public final class MidnightTriggeringPolicy
implements TriggeringPolicy {
    private static final int _MAX_WARNINGS_BEFORE_SEND = 99;
    private DateTime _confirmTime;
    private final int _maxWarnings;
    private int _warnSeen;

    private MidnightTriggeringPolicy(int maxWarnings) {
        this._maxWarnings = maxWarnings;
    }

    @PluginFactory
    public static MidnightTriggeringPolicy createPolicy(@PluginAttribute(value="maxWarnings", defaultInt=99) int maxWarnings) {
        return new MidnightTriggeringPolicy(maxWarnings);
    }

    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        if (event.getLevel().isMoreSpecificThan(Level.ERROR)) {
            return this._trigger();
        }
        if (event.getLevel().isMoreSpecificThan(Level.WARN)) {
            if (++this._warnSeen > this._maxWarnings && this._confirmTime == null) {
                return this._trigger();
            }
        } else {
            if (this._warnSeen > 0 && "MIDNIGHT".equals(event.getLoggerName())) {
                return this._trigger();
            }
            if (this._confirmTime != null && this._confirmTime.isNotAfter(DateTime.now())) {
                this._confirmTime = null;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "MidnightTriggeringPolicy";
    }

    private boolean _trigger() {
        this._warnSeen = 0;
        this._confirmTime = DateTime.now().nextDay();
        return true;
    }
}

