/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.ValueConverter;

@Immutable
public abstract class Version {
    public static final String APPLICATION_NAME_ATTRIBUTE = "Application-Name";
    public static final String BUNDLE_VERSION_ATTRIBUTE = "Bundle-Version";
    public static final String IMPLEMENTATION_REVISION_ATTRIBUTE = "Implementation-Revision";
    public static final String PROBLEM_INDICATOR = "?";
    public static final String SPECIFICATION_VERSION_ATTRIBUTE = "Specification-Version";
    public static final String UNKNOWN_INDICATOR = "*";

    @Nonnull
    @CheckReturnValue
    public static Optional<DateTime> getContainerDateTime(@Nonnull String resourcePath) {
        long millis;
        URL url = Version._getThisCLassLoader().getResource(resourcePath);
        if (url != null) {
            URLConnection connection;
            try {
                connection = url.openConnection();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            millis = connection.getLastModified();
        } else {
            millis = 0L;
        }
        return Optional.ofNullable(millis > 0L ? DateTime.fromMillis(millis) : null);
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<File> getContainerFile(@Nonnull String resourcePath) {
        URL url = Version._getThisCLassLoader().getResource(resourcePath);
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            String path = url.getPath();
            int index = path.indexOf(33);
            try {
                url = new URL(index >= 0 ? path.substring(0, index) : path);
            }
            catch (MalformedURLException exception) {
                throw new RuntimeException(exception);
            }
        } else if (!"file".equalsIgnoreCase(url.getProtocol())) {
            url = null;
        }
        try {
            return url != null ? Optional.of(new File(url.toURI())) : Optional.empty();
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    public static Manifest getManifest(@Nonnull Class<?> objectClass) {
        Manifest manifest;
        try {
            URL url = objectClass.getProtectionDomain().getCodeSource().getLocation();
            JarFile jarFile = new JarFile(url.getPath());
            manifest = jarFile.getManifest();
            jarFile.close();
        }
        catch (Exception exception) {
            manifest = null;
        }
        return manifest != null ? manifest : new Manifest();
    }

    @Nonnull
    @CheckReturnValue
    public static String getManifestAttribute(@Nonnull Manifest manifest, @Nonnull String attributeName) {
        String attribute = manifest.getMainAttributes().getValue(attributeName);
        return attribute != null ? attribute : PROBLEM_INDICATOR;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<DateTime> getContainerDateTime() {
        return Version.getContainerDateTime(this._getThisResourcePath());
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<File> getContainerFile() {
        return Version.getContainerFile(this._getThisResourcePath());
    }

    @Nonnull
    @CheckReturnValue
    public final String getImplementationRevision() {
        String revision = Version.getManifestAttribute(Version.getManifest(this.getClass()), IMPLEMENTATION_REVISION_ATTRIBUTE);
        return revision != PROBLEM_INDICATOR ? revision : UNKNOWN_INDICATOR;
    }

    @Nonnull
    @CheckReturnValue
    public final String getImplementationTitle() {
        String title = this.getClass().getPackage().getImplementationTitle();
        return title != null ? title : UNKNOWN_INDICATOR;
    }

    @Nonnull
    @CheckReturnValue
    public final String getImplementationVendor() {
        String version = this.getClass().getPackage().getImplementationVendor();
        return version != null ? version : UNKNOWN_INDICATOR;
    }

    @Nonnull
    @CheckReturnValue
    public final String getImplementationVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version != null ? version : UNKNOWN_INDICATOR;
    }

    @Nonnull
    @CheckReturnValue
    public final String getSpecificationTitle() {
        String title = this.getClass().getPackage().getSpecificationTitle();
        return title != null ? title : UNKNOWN_INDICATOR;
    }

    @Nonnull
    @CheckReturnValue
    public final String getSpecificationVendor() {
        String version = this.getClass().getPackage().getSpecificationVendor();
        return version != null ? version : UNKNOWN_INDICATOR;
    }

    @Nonnull
    @CheckReturnValue
    public final String getSpecificationVersion() {
        String version = this.getClass().getPackage().getSpecificationVersion();
        return version != null ? version : UNKNOWN_INDICATOR;
    }

    public void logImplementation(boolean quiet) {
        Logger logger = Logger.getInstance(this.getClass());
        Logger.LogLevel logLevel = quiet ? Logger.LogLevel.DEBUG : Logger.LogLevel.INFO;
        logger.log(logLevel, BaseMessages.IMPLEMENTATION_TITLE, this.getImplementationTitle());
        logger.log(logLevel, BaseMessages.IMPLEMENTATION_VENDOR, this.getImplementationVendor());
        logger.log(logLevel, BaseMessages.IMPLEMENTATION_VERSION, this.getImplementationVersion());
        logger.log(logLevel, BaseMessages.IMPLEMENTATION_REVISION, this.getImplementationRevision());
    }

    public void logSpecification(boolean quiet) {
        Logger logger = Logger.getInstance(this.getClass());
        Logger.LogLevel logLevel = quiet ? Logger.LogLevel.DEBUG : Logger.LogLevel.INFO;
        logger.log(logLevel, BaseMessages.SPECIFICATION_TITLE, this.getSpecificationTitle());
        logger.log(logLevel, BaseMessages.SPECIFICATION_VENDOR, this.getSpecificationVendor());
        logger.log(logLevel, BaseMessages.SPECIFICATION_VERSION, this.getSpecificationVersion());
    }

    public void logSystemInfo(@Nonnull String identification) {
        this.logSystemInfo(identification, false);
    }

    public void logSystemInfo(@Nonnull String identification, boolean quiet) {
        Optional<byte[]> node;
        Logger logger = Logger.getInstance(this.getClass());
        Logger.LogLevel logLevel = quiet ? Logger.LogLevel.DEBUG : Logger.LogLevel.INFO;
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        String vmInfo = System.getProperty("java.vm.info");
        String vmVendor = System.getProperty("java.vm.vendor");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String userDir = System.getProperty("user.dir");
        String osPatchLevel = System.getProperty("sun.os.patch.level", "");
        if (osPatchLevel.length() > 0) {
            osPatchLevel = "unknown".equals(osPatchLevel) ? "" : " " + osPatchLevel;
        }
        logger.log(logLevel, BaseMessages.SYSTEM_INFO, identification);
        logger.log(logLevel, BaseMessages.JAVA_VERSION, javaVersion, javaVendor);
        logger.log(logLevel, BaseMessages.JAVA_VM, vmName, vmVersion, vmInfo, vmVendor);
        logger.log(logLevel, BaseMessages.OPERATING_SYSTEM, osName, osVersion, osPatchLevel, osArch);
        logger.log(logLevel, BaseMessages.BASE_DIRECTORY, userDir);
        if (logger.isDebugEnabled()) {
            String javaHome = System.getProperty("java.home");
            String bootClassPath = System.getProperty("sun.boot.class.path");
            String bootLibraryPath = System.getProperty("sun.boot.library.path");
            String classPath = System.getProperty("java.class.path");
            String libraryPath = System.getProperty("java.library.path");
            String fileEncoding = System.getProperty("file.encoding");
            String userHome = System.getProperty("user.home");
            String userName = System.getProperty("user.name");
            String userCountry = System.getProperty("user.country");
            String userLanguage = System.getProperty("user.language");
            logger.debug(BaseMessages.JAVA_HOME, javaHome);
            if (bootClassPath != null) {
                logger.debug(BaseMessages.BOOT_CLASS_PATH, bootClassPath);
            }
            if (bootLibraryPath != null) {
                logger.debug(BaseMessages.BOOT_LIBRARY_PATH, bootLibraryPath);
            }
            logger.debug(BaseMessages.CLASS_PATH, classPath);
            logger.debug(BaseMessages.LIBRARY_PATH, libraryPath);
            logger.debug(BaseMessages.USER_HOME, userName, userHome);
            logger.debug(BaseMessages.COUNTRY_ETC, userCountry, userLanguage, TimeZone.getDefault().getDisplayName());
            logger.debug(BaseMessages.DEFAULT_LOCALE, Locale.getDefault(), fileEncoding);
        }
        if ((node = UUID.getNode()).isPresent()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (byte value : node.get()) {
                String hex;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('-');
                }
                if ((hex = Integer.toHexString(value & 0xFF)).length() < 2) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(hex);
            }
            logger.log(logLevel, BaseMessages.MAC_ADDRESS, stringBuilder);
        }
        long maxMemory = ValueConverter.roundToMebibytes((long)Runtime.getRuntime().maxMemory());
        logger.log(logLevel, BaseMessages.HEAP_LIMIT, String.valueOf(maxMemory));
        this.logSpecification(quiet);
        this.logImplementation(quiet);
        Logger.logBackEnd();
    }

    private static ClassLoader _getThisCLassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    private String _getThisResourcePath() {
        return this.getClass().getName().replace('.', '/') + ".class";
    }
}

