/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.container;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;

@NotThreadSafe
public class IdentityHashSet<E>
extends AbstractSet<E> {
    private final Map<E, Boolean> _map = new IdentityHashMap<E, Boolean>();

    public IdentityHashSet() {
    }

    public IdentityHashSet(@Nonnull Collection<E> collection) {
        this.addAll(collection);
    }

    @Override
    public boolean add(E object) {
        return this._map.put(Require.notNull(object), Boolean.TRUE) == null;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this._map.remove(object) != null;
    }

    @Override
    public int size() {
        return this._map.size();
    }
}

