/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.util.container;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;

public interface ListMap<K, V>
extends Map<K, List<V>> {
    public void add(@Nonnull K var1, @Nonnull V var2);

    @Nonnull
    @CheckReturnValue
    public List<V> getAll(@Nonnull Object var1);

    @Nonnull
    @CheckReturnValue
    public Optional<V> getFirst(@Nonnull K var1);

    @Nonnull
    @CheckReturnValue
    public Optional<V> getLast(@Nonnull K var1);

    public void put(@Nonnull K var1);

    @Nonnull
    public Optional<V> removeFirst(@Nonnull K var1);

    @Nonnull
    public Optional<V> removeLast(@Nonnull K var1);

    @NotThreadSafe
    public static abstract class Abstract<K, V>
    extends AbstractMap<K, List<V>>
    implements ListMap<K, V>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<K, List<V>> _map;

        protected Abstract(@Nonnull Map<K, List<V>> map) {
            this._map = (Map)Require.notNull(map);
        }

        @Override
        public void add(K key, V value) {
            List<V> values = this._map.get(key);
            if (values == null) {
                values = new LinkedList<V>();
                this._map.put(key, values);
            }
            values.add(value);
        }

        @Override
        public void clear() {
            super.clear();
        }

        @Override
        public ListMap<K, V> clone() {
            Abstract clone;
            try {
                clone = (Abstract)super.clone();
            }
            catch (CloneNotSupportedException exception) {
                throw new InternalError(exception);
            }
            try {
                clone._map = (Map)clone._map.getClass().getMethod("clone", new Class[0]).invoke(clone._map, new Object[0]);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            for (Map.Entry entry : clone.entrySet()) {
                entry.setValue(new LinkedList(entry.getValue()));
            }
            clone.mapReplaced(clone._map);
            return clone;
        }

        @Override
        public boolean containsKey(Object key) {
            return this._map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            for (List<V> list : this._map.values()) {
                if (!list.contains(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<K, List<V>>> entrySet() {
            return this._map.entrySet();
        }

        @Override
        public List<V> get(Object key) {
            return this.getAll(key);
        }

        @Override
        public List<V> getAll(Object key) {
            List<V> all = this._map.get(key);
            return all != null ? all : Collections.emptyList();
        }

        @Override
        public Optional<V> getFirst(K key) {
            List<V> values = this._map.get(key);
            return values != null ? Optional.of(values.get(0)) : Optional.empty();
        }

        @Override
        public Optional<V> getLast(K key) {
            List<V> values = this._map.get(key);
            return values != null ? Optional.of(values.get(values.size() - 1)) : Optional.empty();
        }

        @Override
        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return super.keySet();
        }

        @Override
        public void put(K key) {
            this.put(key, new LinkedList());
        }

        @Override
        public List<V> put(K key, List<V> value) {
            return this._map.put(key, value);
        }

        @Override
        public List<V> remove(Object key) {
            return this._map.remove(key);
        }

        @Override
        public Optional<V> removeFirst(K key) {
            Object value;
            List<V> values = this._map.get(key);
            if (values == null) {
                return Optional.empty();
            }
            Object t = value = values.isEmpty() ? null : (Object)values.remove(0);
            if (values.isEmpty()) {
                this._map.remove(key);
            }
            return Optional.ofNullable(value);
        }

        @Override
        public Optional<V> removeLast(K key) {
            Object value;
            List<V> values = this._map.get(key);
            if (values == null) {
                return Optional.empty();
            }
            Object t = value = values.isEmpty() ? null : (Object)values.remove(values.size() - 1);
            if (values.isEmpty()) {
                this._map.remove(key);
            }
            return Optional.ofNullable(value);
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public Collection<List<V>> values() {
            return this._map.values();
        }

        protected void mapReplaced(@Nonnull Map<K, List<V>> map) {
        }

        private Object readResolve() {
            this.mapReplaced(this._map);
            return this;
        }
    }
}

