/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jnlp.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.JFrame;
import org.rvpf.base.tool.Require;
import org.rvpf.tool.PostInstallAction;

@ThreadSafe
public class PostInstallConfig
implements PostInstallAction {
    public static final String CONFIG_EXEC_PROPERTY = "rvpf.jnlp.config.exec";
    public static final String CONFIG_JAR_PROPERTY = "rvpf.jnlp.config.jar";

    public void onInstallDone(JFrame frame, String installPath) throws PostInstallAction.ActionFailureException {
        File rootDir = new File(installPath).getParentFile();
        Require.success((boolean)rootDir.isDirectory());
        this._installConfig(rootDir);
        PostInstallConfig._runConfig(rootDir);
    }

    private static void _runConfig(File rootDir) throws PostInstallAction.ActionFailureException {
        String command = System.getProperty(CONFIG_EXEC_PROPERTY, "").trim();
        if (command.isEmpty()) {
            return;
        }
        try {
            Process process = Runtime.getRuntime().exec(command, null, rootDir);
            process.waitFor();
            int status = process.exitValue();
            if (status != 0) {
                throw new PostInstallAction.ActionFailureException("Command \"" + command + "\" completed with status '" + status + "'");
            }
        }
        catch (IOException exception) {
            throw new PostInstallAction.ActionFailureException("Failed to execute \"" + command + "\": " + exception.getMessage());
        }
        catch (InterruptedException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void _installConfig(File rootDir) throws PostInstallAction.ActionFailureException {
        String jarName = System.getProperty(CONFIG_JAR_PROPERTY, "").trim();
        if (jarName.isEmpty()) {
            return;
        }
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(jarName);
        if (inputStream == null) {
            throw new PostInstallAction.ActionFailureException("Jar resource '" + jarName + "' not found");
        }
        try (JarInputStream jarStream = new JarInputStream(inputStream, false);){
            JarEntry jarEntry;
            byte[] buffer = new byte[4096];
            while ((jarEntry = jarStream.getNextJarEntry()) != null) {
                String entryName = jarEntry.getName();
                if (!entryName.startsWith("META-INF/")) {
                    if (entryName.endsWith("/")) {
                        File jarFile = new File(rootDir, entryName);
                        if (!jarFile.mkdirs() && !jarFile.isDirectory()) {
                            throw new PostInstallAction.ActionFailureException("Failed to created  directory '" + jarFile + "' for '" + jarName + "'");
                        }
                    } else {
                        try (FileOutputStream outputStream = new FileOutputStream(new File(rootDir, entryName));){
                            int read;
                            while ((read = jarStream.read(buffer)) >= 0) {
                                ((OutputStream)outputStream).write(buffer, 0, read);
                            }
                        }
                    }
                }
                jarStream.closeEntry();
            }
        }
        catch (IOException exception) {
            throw new PostInstallAction.ActionFailureException("Failed to access '" + jarName + "': " + exception.getMessage());
        }
    }
}

