/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jnlp.loader;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.jnlp.loader.CacheManager;
import org.rvpf.jnlp.loader.JNLPException;
import org.rvpf.jnlp.loader.JNLPMessages;
import org.rvpf.jnlp.loader.JNLPProperties;
import org.rvpf.jnlp.loader.Verifier;

public final class JNLP {
    public static final String EXTRACT_DIR_PROPERTY = "extract.dir";
    private static final String _APPLICATION_DESC_ELEMENT = "application-desc";
    private static final String _ARGUMENT_ELEMENT = "argument";
    private static final String _CODEBASE_ATTRIBUTE = "codebase";
    private static final String _HREF_ATTRIBUTE = "href";
    private static final String _JAR_ELEMENT = "jar";
    private static final String _MAIN_ATTRIBUTE = "main";
    private static final String _MAIN_CLASS_ATTRIBUTE = "main-class";
    private static final String _NAME_ATTRIBUTE = "name";
    private static final String _NATIVELIB_ELEMENT = "nativelib";
    private static final String _PROPERTY_ELEMENT = "property";
    private static final String _RESOURCES_ELEMENT = "resources";
    private static final String _TRUE_VALUE = "true";
    private static final String _VALUE_ATTRIBUTE = "value";
    private final LinkedList<String> _arguments = new LinkedList();
    private final LinkedList<File> _jars = new LinkedList();
    private String _mainClassName;
    private final Map<String, String> _properties = new HashMap<String, String>();

    private JNLP() {
    }

    @Nonnull
    @CheckReturnValue
    static JNLP load(@Nonnull URL jnlpURL) throws Exception {
        JNLP jnlp = new JNLP();
        try (CacheManager cacheManager = new CacheManager();){
            jnlp._load(jnlpURL, cacheManager);
        }
        return jnlp;
    }

    @Nonnull
    @CheckReturnValue
    String[] getArguments() {
        return this._arguments.toArray(new String[this._arguments.size()]);
    }

    @Nonnull
    @CheckReturnValue
    List<File> getJars() {
        return this._jars;
    }

    @Nonnull
    @CheckReturnValue
    String getMainClassName() {
        Require.notNull((Object)this._mainClassName);
        return this._mainClassName;
    }

    @Nonnull
    @CheckReturnValue
    Map<String, String> getProperties() {
        return this._properties;
    }

    private static String _getAttribute(XMLElement element, String name) {
        Optional<String> value = element.getAttributeValue(name, Optional.empty());
        return value.isPresent() ? JNLPProperties.getInstance().substitute(value.get(), false) : null;
    }

    private static String _getText(XMLElement element) {
        return JNLPProperties.getInstance().substitute(element.getText(), false);
    }

    private File _fetchResources(XMLElement root, CacheManager cacheManager) throws Exception {
        Optional<String> dirProperty = JNLPProperties.getInstance().getStringValue(EXTRACT_DIR_PROPERTY, Optional.empty());
        File extractDir = dirProperty.isPresent() ? new File(dirProperty.get()) : null;
        String href = JNLP._getAttribute(root, _CODEBASE_ATTRIBUTE);
        if (href != null && !href.endsWith("/")) {
            href = href + '/';
        }
        URL codeBase = href != null ? new URL(href) : null;
        File mainJar = null;
        for (XMLElement xMLElement : root.getChildren(_RESOURCES_ELEMENT)) {
            for (XMLElement xMLElement2 : xMLElement.getChildren()) {
                String name = xMLElement2.getName();
                if (_JAR_ELEMENT.equals(name)) {
                    href = JNLP._getAttribute(xMLElement2, _HREF_ATTRIBUTE);
                    if (href == null) continue;
                    URL url = new URL(codeBase, href);
                    File jar = cacheManager.getFile(url);
                    if (!Verifier.getInstance().verifyJar(jar, cacheManager.isNew(jar), Optional.empty())) {
                        throw new JNLPException(Message.format(JNLPMessages.JAR_FAILED, url));
                    }
                    this._jars.addLast(jar);
                    if (!_TRUE_VALUE.equals(JNLP._getAttribute(xMLElement2, _MAIN_ATTRIBUTE))) continue;
                    if (mainJar != null) {
                        throw new JNLPException(Message.format(JNLPMessages.ONE_MAIN_JAR, new Object[0]));
                    }
                    mainJar = jar;
                    continue;
                }
                if (_NATIVELIB_ELEMENT.equals(name)) {
                    href = JNLP._getAttribute(xMLElement2, _HREF_ATTRIBUTE);
                    if (href == null || extractDir == null) continue;
                    File jar = cacheManager.getFile(new URL(codeBase, href));
                    if (Verifier.getInstance().verifyJar(jar, cacheManager.isNew(jar), Optional.of(extractDir))) continue;
                    throw new JNLPException(Message.format(JNLPMessages.JAR_FAILED, new Object[0]));
                }
                if (!_PROPERTY_ELEMENT.equals(name)) continue;
                this._properties.put(JNLP._getAttribute(xMLElement2, _NAME_ATTRIBUTE), JNLP._getAttribute(xMLElement2, _VALUE_ATTRIBUTE));
            }
        }
        if (this._jars.isEmpty()) {
            throw new JNLPException(Message.format(JNLPMessages.NO_JAR, new Object[0]));
        }
        return mainJar != null ? mainJar : this._jars.getFirst();
    }

    private void _load(URL jnlpURL, CacheManager cacheManager) throws Exception {
        JarFile jarFile;
        File jnlpFile = cacheManager.getFile(jnlpURL);
        XMLElement root = new XMLDocument().parse(jnlpFile, Optional.empty());
        File mainJar = this._fetchResources(root, cacheManager);
        Optional<XMLElement> optionalApplication = root.getFirstChild(_APPLICATION_DESC_ELEMENT);
        String mainClassName = null;
        if (optionalApplication.isPresent()) {
            XMLElement application = optionalApplication.get();
            mainClassName = JNLP._getAttribute(application, _MAIN_CLASS_ATTRIBUTE);
            for (XMLElement xMLElement : application.getChildren(_ARGUMENT_ELEMENT)) {
                this._arguments.addLast(JNLP._getText(xMLElement));
            }
        }
        if (!Verifier.verifyJNLP(jnlpFile, jarFile = new JarFile(mainJar))) {
            throw new JNLPException(Message.format(JNLPMessages.JNLP_FAILED, jnlpFile.getName(), mainJar.getName()));
        }
        if (mainClassName == null) {
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest != null ? manifest.getMainAttributes() : null;
            mainClassName = attributes != null ? attributes.getValue(Attributes.Name.MAIN_CLASS) : null;
        }
        jarFile.close();
        if (mainClassName == null) {
            throw new JNLPException(Message.format(JNLPMessages.NO_MAIN_CLASS, new Object[0]));
        }
        this._mainClassName = mainClassName;
    }
}

