/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jnlp.loader;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.util.container.KeyedValues;

@Immutable
public final class JNLPProperties {
    public static final String RVPF_JNLP_PREFIX = "rvpf.jnlp.";
    private static final JNLPProperties _INSTANCE = new JNLPProperties();
    private final KeyedValues _properties = new KeyedValues(BaseMessages.SYSTEM_TYPE.toString());

    private JNLPProperties() {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith(RVPF_JNLP_PREFIX)) continue;
            this._properties.setValue(name.substring(RVPF_JNLP_PREFIX.length()), entry.getValue());
        }
        this._properties.freeze();
    }

    @Nonnull
    @CheckReturnValue
    static JNLPProperties getInstance() {
        return _INSTANCE;
    }

    @CheckReturnValue
    boolean getBooleanValue(@Nonnull String key) {
        return this._properties.getBoolean(key, false);
    }

    @Nonnull
    @CheckReturnValue
    Optional<ElapsedTime> getElapsedValue(@Nonnull String key, @Nonnull Optional<ElapsedTime> defaultValue, @Nonnull Optional<ElapsedTime> emptyValue) {
        return this._properties.getElapsed(key, defaultValue, emptyValue);
    }

    @CheckReturnValue
    int getIntValue(@Nonnull String key, int defaultValue) {
        return this._properties.getInt(key, defaultValue);
    }

    @Nonnull
    @CheckReturnValue
    Optional<String> getStringValue(@Nonnull String key, @Nonnull Optional<String> defaultValue) {
        return this._properties.getString(key, defaultValue);
    }

    @Nonnull
    @CheckReturnValue
    String substitute(@Nonnull String text, boolean deferred) {
        return this._properties.substitute(text, deferred);
    }
}

