/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jnlp.loader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.jnlp.launcher.Loader;
import org.rvpf.jnlp.loader.JNLP;
import org.rvpf.jnlp.loader.JNLPException;
import org.rvpf.jnlp.loader.JNLPMessages;
import org.rvpf.jnlp.loader.JNLPVersion;

@NotThreadSafe
public class LoaderImpl
implements Loader {
    private static final Logger _LOGGER = Logger.getInstance(LoaderImpl.class);
    private JNLP _jnlp;

    public LoaderImpl() {
        JNLPVersion version = new JNLPVersion();
        version.logSystemInfo(this.getClass().getSimpleName());
        _LOGGER.info(JNLPMessages.IMPLEMENTATION, version.getImplementationTitle(), version.getImplementationVersion());
    }

    public String[] getArguments() {
        return this._jnlp.getArguments();
    }

    public String getMainClassName() {
        return this._jnlp.getMainClassName();
    }

    public Map<String, String> getProperties() {
        return this._jnlp.getProperties();
    }

    public URL[] getURLs() {
        Iterator<File> jarsIterator = this._jnlp.getJars().iterator();
        URL[] urls = new URL[this._jnlp.getJars().size()];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = jarsIterator.next().toURI().toURL();
                continue;
            }
            catch (MalformedURLException exception) {
                throw new InternalError(exception);
            }
        }
        _LOGGER.info(JNLPMessages.STARTING_APPLICATION, new Object[0]);
        return urls;
    }

    public boolean loadJNLP(Optional<URL> jnlpURL) {
        try {
            if (!jnlpURL.isPresent()) {
                throw new JNLPException(Message.format(JNLPMessages.NO_JNLP_URL, new Object[0]));
            }
            _LOGGER.info(JNLPMessages.JNLP_FILE, jnlpURL.get());
            this._jnlp = JNLP.load(jnlpURL.get());
            _LOGGER.debug(JNLPMessages.VERIFICATION_COMPLETED, new Object[0]);
        }
        catch (JNLPException exception) {
            _LOGGER.error(BaseMessages.VERBATIM, exception.getMessage());
            return false;
        }
        catch (Throwable exception) {
            _LOGGER.error(exception, JNLPMessages.UNEXPECTED_EXCEPTION, new Object[0]);
            return false;
        }
        return true;
    }
}

