/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jnlp.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.CodeSigner;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPathValidator;
import java.security.cert.PKIXParameters;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.jnlp.loader.JNLPMessages;

@ThreadSafe
final class Verifier {
    private static final String _CERTS_PATH = "lib/security/cacerts";
    private static final String _JAVA_HOME_PROPERTY = "java.home";
    private static final String _JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";
    private static final Logger _LOGGER = Logger.getInstance(Verifier.class);
    private static final int _STREAM_BUFFER_SIZE = 32768;
    private static final String _TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String _TRUST_STORE_PROVIDER_PROPERTY = "javax.net.ssl.trustStoreProvider";
    private static final String _TRUST_STORE_TYPE_PROPERTY = "javax.net.ssl.trustStoreType";
    @GuardedBy(value="class")
    private static Verifier _instance;
    @GuardedBy(value="this")
    private final Set<CodeSigner> _validatedSigners = new HashSet<CodeSigner>();
    @GuardedBy(value="this")
    private final CertPathValidator _validator;
    @GuardedBy(value="this")
    private final PKIXParameters _validatorParams;

    private Verifier() {
        File storeFile;
        try {
            this._validator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
        }
        catch (NoSuchAlgorithmException exception) {
            throw new InternalError(exception);
        }
        String defaultStoreType = KeyStore.getDefaultType();
        String storeType = System.getProperty(_TRUST_STORE_TYPE_PROPERTY, defaultStoreType);
        String storeProvider = System.getProperty(_TRUST_STORE_PROVIDER_PROPERTY);
        String storeProperty = System.getProperty(_TRUST_STORE_PROPERTY);
        File file = storeFile = storeProperty != null ? new File(storeProperty) : new File(System.getProperty(_JAVA_HOME_PROPERTY), _CERTS_PATH);
        if (storeType != defaultStoreType) {
            _LOGGER.info(BaseMessages.STORE_TYPE, "TrustStore", storeType);
        }
        if (storeProvider != null) {
            _LOGGER.info(BaseMessages.STORE_PROVIDER, "TrustStore", storeProvider);
        }
        _LOGGER.info(BaseMessages.STORE_PATH, "TrustStore", storeFile.getAbsolutePath());
        try {
            KeyStore store = storeProvider != null ? KeyStore.getInstance(storeType, storeProvider) : KeyStore.getInstance(storeType);
            try (FileInputStream stream = new FileInputStream(storeFile);){
                store.load(stream, null);
            }
            this._validatorParams = new PKIXParameters(store);
            this._validatorParams.setRevocationEnabled(storeProperty == null);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    static synchronized Verifier getInstance() {
        if (_instance == null) {
            _instance = new Verifier();
        }
        return _instance;
    }

    @CheckReturnValue
    static boolean verifyJNLP(@Nonnull File jnlpFile, @Nonnull JarFile mainJar) throws IOException {
        JarEntry jarEntry = mainJar.getJarEntry(_JNLP_ENTRY);
        if (jarEntry == null) {
            return false;
        }
        long size = jarEntry.getSize();
        if (size != jnlpFile.length()) {
            return false;
        }
        byte[] jarBuffer = new byte[(int)size];
        try (BufferedInputStream jarInputStream = new BufferedInputStream(mainJar.getInputStream(jarEntry));){
            if ((long)((InputStream)jarInputStream).read(jarBuffer) != size) {
                boolean bl = false;
                return bl;
            }
        }
        byte[] fileBuffer = new byte[(int)size];
        try (BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(jnlpFile));){
            if ((long)((InputStream)fileInputStream).read(fileBuffer) != size) {
                boolean bl = false;
                return bl;
            }
        }
        return Arrays.equals(fileBuffer, jarBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    boolean verifyJar(@Nonnull File cachedFile, boolean isNew, @Nonnull Optional<File> extractDir) throws IOException {
        JarFile jarFile = new JarFile(cachedFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        Object[] signers = null;
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.getName().startsWith("META-INF/") || entry.getName().endsWith("/") || entry.getSize() == 0L) continue;
            Verifier._streamEntry(jarFile, entry, isNew, extractDir);
            Object[] entrySigners = entry.getCodeSigners();
            if (entrySigners == null || entrySigners.length == 0) {
                _LOGGER.error(JNLPMessages.ENTRY_NOT_SIGNED, new Object[0]);
                return false;
            }
            if (signers == null) {
                signers = entrySigners;
                continue;
            }
            if (Arrays.equals(entrySigners, signers)) continue;
            _LOGGER.error(JNLPMessages.CERTIFICATES_DIFFER, new Object[0]);
            return false;
        }
        block6: for (Map.Entry<String, Attributes> entry : jarFile.getManifest().getEntries().entrySet()) {
            for (Object key : entry.getValue().keySet()) {
                String string = key.toString().toUpperCase(Locale.ROOT);
                if (!string.endsWith("-DIGEST") && !string.contains("-DIGEST-")) continue;
                if (jarFile.getEntry(entry.getKey()) != null) continue block6;
                _LOGGER.error(JNLPMessages.SIGNED_ENTRY_MISSING, new Object[0]);
                return false;
            }
        }
        if (signers != null) {
            Verifier verifier = this;
            synchronized (verifier) {
                for (void var11_15 : signers) {
                    if (this._validatedSigners.contains(var11_15)) continue;
                    try {
                        this._validator.validate(var11_15.getSignerCertPath(), this._validatorParams);
                    }
                    catch (GeneralSecurityException exception) {
                        _LOGGER.error((Throwable)exception, JNLPMessages.SIGNATURE_VALIDATION, new Object[0]);
                        return false;
                    }
                    this._validatedSigners.add((CodeSigner)var11_15);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _streamEntry(JarFile jarFile, JarEntry entry, boolean isNew, Optional<File> extractDir) throws IOException {
        try (OutputStream outputStream = null;
             InputStream inputStream = jarFile.getInputStream(entry);){
            int count;
            if (extractDir.isPresent() && entry.getName().indexOf(47) < 0) {
                File file = new File(extractDir.get(), entry.getName());
                if (isNew || !file.exists()) {
                    outputStream = new FileOutputStream(file);
                }
            }
            byte[] buffer = new byte[32768];
            while ((count = inputStream.read(buffer, 0, buffer.length)) > 0) {
                if (outputStream == null) continue;
                outputStream.write(buffer, 0, count);
            }
        }
    }
}

