/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.ForwarderMessages;

public final class BatchControl {
    private final int _limit;
    private boolean _reset;
    private Optional<DateTime> _stamp = Optional.empty();
    private final Optional<ElapsedTime> _timeout;
    private final Optional<ElapsedTime> _wait;

    BatchControl(int limit, @Nonnull Optional<ElapsedTime> timeout, @Nonnull Optional<ElapsedTime> wait) {
        this._limit = limit;
        this._timeout = timeout;
        this._wait = wait;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @CheckReturnValue
    public int getLimit() {
        return this._limit;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<ElapsedTime> getWait() {
        ElapsedTime wait;
        if (this._stamp.isPresent()) {
            ElapsedTime elapsed = DateTime.now().sub(this._stamp.get());
            ElapsedTime left = elapsed.compareTo(this._timeout.get()) < 0 ? this._timeout.get().sub(elapsed) : ElapsedTime.EMPTY;
            wait = left.min(this._wait);
        } else {
            ElapsedTime elapsedTime = wait = this._wait.isPresent() ? this._wait.get().min(this._timeout) : (ElapsedTime)this._timeout.orElse(null);
            if (this._reset) {
                if (this._timeout.isPresent()) {
                    this._stamp = Optional.of(DateTime.now());
                }
                this._reset = false;
            }
        }
        return Optional.ofNullable(wait);
    }

    public void reset() {
        this._stamp = Optional.empty();
        this._reset = true;
    }

    public static final class Builder {
        public static final String BATCH_LIMIT_PROPERTY = "batch.limit";
        public static final String BATCH_TIMEOUT_PROPERTY = "batch.timeout";
        public static final String BATCH_WAIT_PROPERTY = "batch.wait";
        private int _defaultLimit;
        private Optional<ElapsedTime> _defaultWait;
        private int _limit;
        private Logger _logger;
        private Optional<ElapsedTime> _timeout;
        private Optional<ElapsedTime> _wait;

        @Nonnull
        public Builder applyProperties(@Nonnull KeyedGroups moduleProperties) {
            this._limit = moduleProperties.getInt(BATCH_LIMIT_PROPERTY, this._defaultLimit);
            this._timeout = moduleProperties.getElapsed(BATCH_TIMEOUT_PROPERTY, Optional.empty(), Optional.of(ElapsedTime.EMPTY));
            this._wait = moduleProperties.getElapsed(BATCH_WAIT_PROPERTY, !this._timeout.isPresent() ? this._defaultWait : Optional.empty(), Optional.empty());
            return this;
        }

        public BatchControl build() {
            Optional<ElapsedTime> wait;
            int limit = this._limit;
            if (limit < Integer.MAX_VALUE) {
                this._logger.debug((Messages.Entry)ForwarderMessages.BATCH_SIZE_LIMIT, new Object[]{String.valueOf(limit)});
            } else {
                this._logger.debug((Messages.Entry)ForwarderMessages.NO_BATCH_LIMIT, new Object[0]);
            }
            Optional<ElapsedTime> timeout = this._timeout;
            if (timeout.isPresent()) {
                this._logger.debug((Messages.Entry)ForwarderMessages.BATCH_TIMEOUT, new Object[]{timeout.get()});
            }
            if ((wait = this._wait).isPresent()) {
                this._logger.debug((Messages.Entry)ForwarderMessages.BATCH_WAIT, new Object[]{wait.get()});
            }
            return new BatchControl(limit, timeout, wait);
        }

        @Nonnull
        public Builder setDefaultLimit(int defaultLimit) {
            this._defaultLimit = defaultLimit;
            return this;
        }

        @Nonnull
        public Builder setDefaultWait(@Nonnull Optional<ElapsedTime> defaultWait) {
            this._defaultWait = defaultWait;
            return this;
        }

        @Nonnull
        public Builder setLogger(@Nonnull Logger logger) {
            this._logger = logger;
            return this;
        }
    }
}

