/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.ClassDef;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.SnoozeAlarm;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.document.loader.MetadataDocumentLoader;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderServiceAppImpl;
import org.rvpf.forwarder.filter.ForwarderFilter;
import org.rvpf.metadata.Metadata;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;

public interface ForwarderModule {
    @Nonnull
    @CheckReturnValue
    public BatchControl getBatchControl();

    @Nonnull
    @CheckReturnValue
    public Config getConfig();

    @Nonnull
    @CheckReturnValue
    public Service getService();

    @CheckReturnValue
    public boolean isReliable();

    @CheckReturnValue
    public boolean needsMetadata();

    @CheckReturnValue
    public boolean onMetadataRefreshed();

    @CheckReturnValue
    public boolean setUp(@Nonnull ForwarderServiceAppImpl var1, @Nonnull KeyedGroups var2);

    public void start() throws InterruptedException, ServiceNotAvailableException;

    public void stop();

    public void tearDown();

    @NotThreadSafe
    public static abstract class Abstract
    implements ForwarderModule {
        public static final String BATCH_LIMIT_PROPERTY = "batch.limit";
        public static final String CONNECTION_RETRY_DELAY_PROPERTY = "connection.retry.delay";
        public static final ElapsedTime DEFAULT_CONNECTION_RETRY_DELAY = ElapsedTime.fromMillis((long)60000L);
        public static final String FILTER_CLASS_PROPERTY = "filter.class";
        public static final String FILTER_PROPERTIES = "filter";
        public static final String MODULE_UUID_PROPERTY = "module.uuid";
        public static final String PASSWORD_PROPERTY = "password";
        public static final String RELIABLE_PROPERTY = "reliable";
        public static final String TRACES_PROPERTY = "traces";
        public static final String USER_PROPERTY = "user";
        private static final Optional<ElapsedTime> _DEFAULT_BATCH_WAIT = Optional.empty();
        private BatchControl _batchControl;
        private ElapsedTime _connectionRetryDelay;
        private final List<ForwarderFilter> _filters = new LinkedList<ForwarderFilter>();
        private ForwarderServiceAppImpl _forwarderAppImpl;
        private final Logger _logger = Logger.getInstance(this.getClass());
        private Metadata _metadata;
        private Optional<Boolean> _reliable = Optional.empty();
        private final Traces _traces = new Traces();
        private UUID _uuid;

        @Override
        public final BatchControl getBatchControl() {
            return (BatchControl)Require.notNull((Object)this._batchControl);
        }

        @Override
        public final Config getConfig() {
            return this._forwarderAppImpl.getConfig();
        }

        @Nonnull
        @CheckReturnValue
        public final KeyedGroups getConfigProperties() {
            return this._forwarderAppImpl.getConfigProperties();
        }

        @Override
        public final Service getService() {
            return this._forwarderAppImpl.getService();
        }

        @Nonnull
        @CheckReturnValue
        public final Logger getThisLogger() {
            return this._logger;
        }

        @Nonnull
        @CheckReturnValue
        public final Traces getTraces() {
            return this._traces;
        }

        @Override
        public boolean isReliable() {
            return this._reliable.isPresent() ? this._reliable.get() : false;
        }

        @Override
        public boolean needsMetadata() {
            for (ForwarderFilter filter : this._filters) {
                if (!filter.needsMetadata()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onMetadataRefreshed() {
            for (ForwarderFilter filter : this._filters) {
                if (filter.onMetadataRefreshed()) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean setUp(ForwarderServiceAppImpl forwarderApp, KeyedGroups moduleProperties) {
            this._forwarderAppImpl = forwarderApp;
            Optional uuid = moduleProperties.getString(MODULE_UUID_PROPERTY);
            if (uuid.isPresent()) {
                if (!UUID.isUUID((String)((String)uuid.get()))) {
                    this.getThisLogger().error((Messages.Entry)ForwarderMessages.BAD_MODULE_UUID, new Object[]{uuid.get()});
                    return false;
                }
                this._uuid = (UUID)UUID.fromString((String)((String)uuid.get())).get();
                this.getThisLogger().debug((Messages.Entry)ForwarderMessages.MODULE_UUID, new Object[]{this._uuid});
            }
            this._batchControl = BatchControl.newBuilder().setDefaultLimit(this.getDefaultBatchLimit()).setDefaultWait(this.getDefaultBatchWait()).setLogger(this.getThisLogger()).applyProperties(moduleProperties).build();
            this._connectionRetryDelay = moduleProperties.getElapsed(CONNECTION_RETRY_DELAY_PROPERTY, Optional.of(DEFAULT_CONNECTION_RETRY_DELAY), Optional.of(DEFAULT_CONNECTION_RETRY_DELAY)).orElse(null);
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.CONNECTION_RETRY_DELAY, new Object[]{this._connectionRetryDelay});
            if (!SnoozeAlarm.validate((ElapsedTime)this._connectionRetryDelay, (Object)this, (Messages.Entry)ServiceMessages.CONNECTION_RETRY_DELAY_TEXT)) {
                return false;
            }
            if (!this._traces.setUp(this._forwarderAppImpl.getDataDir(), this.getConfigProperties().getGroup(TRACES_PROPERTY), this._forwarderAppImpl.getSourceUUID(), moduleProperties.getString(TRACES_PROPERTY))) {
                return false;
            }
            for (KeyedGroups filterProperties : moduleProperties.getGroups(FILTER_PROPERTIES)) {
                Optional classDef = filterProperties.getClassDef(FILTER_CLASS_PROPERTY, Optional.empty());
                if (!classDef.isPresent()) {
                    this.getThisLogger().error((Messages.Entry)ForwarderMessages.FILTER_PROPERTY_MISSING, new Object[]{FILTER_CLASS_PROPERTY});
                    return false;
                }
                ForwarderFilter filter = (ForwarderFilter)((ClassDef)classDef.get()).createInstance(ForwarderFilter.class);
                if (filter == null) {
                    return false;
                }
                this._filters.add(filter);
                if (filter.setUp(this, filterProperties)) continue;
                return false;
            }
            this._reliable = moduleProperties.getBoolean(RELIABLE_PROPERTY, Optional.empty());
            return this.setUp(moduleProperties);
        }

        @Override
        public void tearDown() {
            for (ForwarderFilter filter : this._filters) {
                filter.tearDown();
            }
            this._traces.tearDown();
            this._forwarderAppImpl = null;
        }

        @Nonnull
        @CheckReturnValue
        protected final Serializable[] filter(@Nonnull Serializable[] messages) throws InterruptedException, ServiceNotAvailableException {
            if (this._filters.isEmpty() || messages.length == 0) {
                return messages;
            }
            ArrayList messageList = new ArrayList(messages.length);
            for (Serializable message : messages) {
                if (message == null) continue;
                LinkedList<Serializable> filteredMessages = new LinkedList<Serializable>();
                filteredMessages.add(message);
                for (ForwarderFilter filter : this._filters) {
                    ListIterator<Serializable> iterator = filteredMessages.listIterator();
                    while (iterator.hasNext()) {
                        Serializable[] filtered = filter.filter((Serializable)iterator.next());
                        iterator.remove();
                        for (Serializable serializable : filtered) {
                            iterator.add(serializable);
                        }
                    }
                }
                messageList.addAll(filteredMessages);
            }
            return messageList.toArray(new Serializable[messageList.size()]);
        }

        @Nonnull
        @CheckReturnValue
        protected final ElapsedTime getConnectionRetryDelay() {
            return (ElapsedTime)Require.notNull((Object)this._connectionRetryDelay);
        }

        @CheckReturnValue
        protected abstract int getDefaultBatchLimit();

        @Nonnull
        @CheckReturnValue
        protected Optional<ElapsedTime> getDefaultBatchWait() {
            return _DEFAULT_BATCH_WAIT;
        }

        @Nonnull
        @CheckReturnValue
        protected final ForwarderServiceAppImpl getForwarderAppImpl() {
            return (ForwarderServiceAppImpl)Require.notNull((Object)this._forwarderAppImpl);
        }

        @Nonnull
        @CheckReturnValue
        protected final Metadata getMetadata() {
            return (Metadata)Require.notNull((Object)this._metadata);
        }

        @Nonnull
        @CheckReturnValue
        protected Optional<Boolean> getReliable() {
            return this._reliable;
        }

        @CheckReturnValue
        protected final boolean loadMetadata(@Nonnull MetadataFilter metadataFilter) {
            Require.success((boolean)this.needsMetadata());
            this._metadata = MetadataDocumentLoader.fetchMetadata(metadataFilter, Optional.of(this.getConfig()), Optional.ofNullable(this._uuid), Optional.empty());
            if (this._metadata != null) {
                this._metadata.setService(this._forwarderAppImpl.getService());
            }
            return this._metadata != null;
        }

        protected void setReliable(@Nonnull Boolean reliable) {
            this._reliable = Optional.of(reliable);
        }

        @CheckReturnValue
        protected abstract boolean setUp(@Nonnull KeyedGroups var1);

        protected static abstract class AbstractInputOutput
        implements ModuleInputOutput {
            protected AbstractInputOutput() {
            }

            @Override
            public boolean commit() {
                return true;
            }

            @Override
            public boolean isReliable() {
                return false;
            }

            @Override
            public boolean setUp(KeyedGroups moduleProperties) {
                return true;
            }

            @Override
            public void tearDown() {
            }
        }

        protected static interface ModuleInputOutput {
            public void close();

            @CheckReturnValue
            public boolean commit();

            @Nonnull
            @CheckReturnValue
            public String getDisplayName();

            @CheckReturnValue
            public boolean isClosed();

            @CheckReturnValue
            public boolean isReliable();

            @CheckReturnValue
            public boolean open() throws InterruptedException;

            @CheckReturnValue
            public boolean setUp(@Nonnull KeyedGroups var1);

            public void tearDown();
        }
    }
}

