/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ClassDef;
import org.rvpf.base.alert.Signal;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.input.InputModule;
import org.rvpf.forwarder.output.OutputModule;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.app.ServiceAppImpl;

public final class ForwarderServiceAppImpl
extends ServiceAppImpl {
    public static final String MODULE_CLASS_PROPERTY = "module.class";
    public static final String MODULE_PROPERTIES = "forwarder.module";
    private int _batchLimit;
    private final List<InputModule> _inputs = new LinkedList<InputModule>();
    private boolean _needsMetadata;
    private final List<OutputModule> _outputs = new LinkedList<OutputModule>();

    public int getOutputsSize() {
        return this._outputs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onSignal(Signal signal) {
        if ("RefreshMetadata".equalsIgnoreCase(signal.getName())) {
            if (this._needsMetadata) {
                List<ForwarderModule.Abstract> list = this._outputs;
                synchronized (list) {
                    for (ForwarderModule forwarderModule : this._outputs) {
                        if (forwarderModule.onMetadataRefreshed()) continue;
                        return true;
                    }
                }
                list = this._inputs;
                synchronized (list) {
                    for (ForwarderModule forwarderModule : this._inputs) {
                        if (forwarderModule.onMetadataRefreshed()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public boolean output(@Nonnull Serializable[] messages) throws InterruptedException, ServiceNotAvailableException {
        int batchLimit = this._batchLimit;
        List<OutputModule> list = this._outputs;
        synchronized (list) {
            for (int start = 0; start < messages.length; start += batchLimit) {
                int size = Math.min(messages.length - start, batchLimit);
                Serializable[] batch = new Serializable[size];
                System.arraycopy(messages, start, batch, 0, size);
                for (OutputModule outputModule : this._outputs) {
                    if (outputModule.output(batch)) continue;
                    return false;
                }
                for (OutputModule outputModule : this._outputs) {
                    if (outputModule.commit()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean setUp(Service service) {
        if (!super.setUp(service)) {
            return false;
        }
        Config config = service.getConfig();
        KeyedGroups[] modulesGroup = config.getPropertiesGroups(MODULE_PROPERTIES);
        if (modulesGroup.length == 0) {
            this.getThisLogger().warn((Messages.Entry)ForwarderMessages.NO_MODULES, new Object[0]);
        }
        this._batchLimit = Integer.MAX_VALUE;
        service.saveConfigState();
        boolean outputIsReliable = true;
        for (KeyedGroups moduleProperties : modulesGroup) {
            Optional classDef = moduleProperties.getClassDef(MODULE_CLASS_PROPERTY, Optional.empty());
            if (!classDef.isPresent()) {
                this.getThisLogger().error((Messages.Entry)ForwarderMessages.MODULE_PROPERTY_MISSING, new Object[]{MODULE_CLASS_PROPERTY});
                return false;
            }
            ForwarderModule module = (ForwarderModule)((ClassDef)classDef.get()).createInstance(ForwarderModule.class);
            if (module == null) {
                return false;
            }
            service.starting();
            if (!module.setUp(this, moduleProperties)) {
                module.tearDown();
                return false;
            }
            service.restoreConfigState();
            this._needsMetadata |= module.needsMetadata();
            if (module instanceof OutputModule) {
                outputIsReliable &= module.isReliable();
                this._batchLimit = Math.min(this._batchLimit, module.getBatchControl().getLimit());
                this._outputs.add((OutputModule)module);
            } else {
                this._inputs.add((InputModule)module);
            }
            if (!this.getThisLogger().isDebugEnabled()) continue;
            this.getThisLogger().debug(() -> new Message((Messages.Entry)ServiceMessages.MODULE_LOADED, new Object[]{module.getClass().getName()}));
        }
        if (!outputIsReliable && this.getOutputsSize() > 1) {
            this.getThisLogger().error((Messages.Entry)ForwarderMessages.OUTPUT_UNRELIABLE_SIBLING, new Object[0]);
            return false;
        }
        if (this._batchLimit < Integer.MAX_VALUE) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.OUTPUT_BATCH_LIMIT, new Object[]{String.valueOf(this._batchLimit)});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            List<ForwarderModule.Abstract> list = this._outputs;
            synchronized (list) {
                for (ForwarderModule forwarderModule : this._outputs) {
                    forwarderModule.start();
                }
            }
            list = this._inputs;
            synchronized (list) {
                for (ForwarderModule forwarderModule : this._inputs) {
                    forwarderModule.start();
                }
            }
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<ForwarderModule.Abstract> list = this._inputs;
        synchronized (list) {
            for (ForwarderModule forwarderModule : this._inputs) {
                forwarderModule.stop();
            }
        }
        list = this._outputs;
        synchronized (list) {
            for (ForwarderModule forwarderModule : this._outputs) {
                forwarderModule.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        List<ForwarderModule.Abstract> list = this._inputs;
        synchronized (list) {
            for (ForwarderModule forwarderModule : this._inputs) {
                forwarderModule.tearDown();
            }
            this._inputs.clear();
        }
        list = this._outputs;
        synchronized (list) {
            for (ForwarderModule forwarderModule : this._outputs) {
                forwarderModule.tearDown();
            }
            this._outputs.clear();
        }
        super.tearDown();
    }
}

