/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.UUID;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.ForwarderFilter;

public class AlertFilter
extends ForwarderFilter.Abstract {
    private UUID _mark;

    @Override
    public Serializable[] filter(Serializable message) {
        Serializable[] serializableArray;
        if (message instanceof Alert) {
            if (!((Alert)message).addVisit(this._mark)) {
                this.getThisLogger().trace((Messages.Entry)ForwarderMessages.ALERT_DROPPED, new Object[]{message});
                message = null;
            }
        } else {
            this.logDropped(ForwarderMessages.MESSAGE_CLASS_DROPPED, message.getClass().getName());
            message = null;
        }
        if (message != null) {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = message;
        } else {
            serializableArray = NO_MESSAGES;
        }
        return serializableArray;
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        Optional<UUID> mark = this.getUUID();
        this._mark = mark.isPresent() ? mark.get() : forwarderModule.getConfig().getService().getSourceUUID();
        return true;
    }
}

