/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.rvpf.base.ClassDef;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.ForwarderFilter;

public final class ClassFilter
extends ForwarderFilter.Abstract {
    public static final String ALLOWED_CLASS_PROPERTY = "allowed.class";
    public static final String DROPPED_CLASS_PROPERTY = "dropped.class";
    private final Set<Class<?>> _allowed = new HashSet();
    private final Set<Class<?>> _dropped = new HashSet();

    @Override
    public Serializable[] filter(Serializable message) {
        Serializable[] serializableArray;
        Class<?> messageClass = message.getClass();
        if (this._dropped.isEmpty()) {
            if (!this._allowed.contains(messageClass)) {
                message = null;
            }
        } else if ((this._allowed.isEmpty() || this._allowed.contains(messageClass)) && this._dropped.contains(messageClass)) {
            message = null;
        }
        if (message == null) {
            this.logDropped(ForwarderMessages.MESSAGE_CLASS_DROPPED, messageClass.getName());
        }
        if (message != null) {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = message;
        } else {
            serializableArray = NO_MESSAGES;
        }
        return serializableArray;
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        Class messageClass;
        boolean success = super.setUp(forwarderModule, filterProperties);
        for (ClassDef classDef : filterProperties.getClassDefs(ALLOWED_CLASS_PROPERTY)) {
            messageClass = classDef.getInstanceClass();
            if (messageClass != null) {
                this._allowed.add(messageClass);
                continue;
            }
            success = false;
        }
        for (ClassDef classDef : filterProperties.getClassDefs(DROPPED_CLASS_PROPERTY)) {
            messageClass = classDef.getInstanceClass();
            if (messageClass != null) {
                this._dropped.add(messageClass);
                continue;
            }
            success = false;
        }
        return success;
    }
}

