/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.security.CryptException;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.ForwarderFilter;

public abstract class CryptFilter
extends ForwarderFilter.Abstract {
    public static final String STRICT_PROPERTY = "strict";
    private final Crypt _crypt = new Crypt();
    private boolean _strict;

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        Config config = this.getModule().getConfig();
        SecurityContext securityContext = new SecurityContext(this.getThisLogger());
        KeyedGroups securityProperties = filterProperties.getGroup("security");
        if (!securityContext.setUp((KeyedGroups)config.getProperties(), securityProperties)) {
            return false;
        }
        if (!this._crypt.setUp(securityContext.getCryptProperties(), Optional.empty())) {
            return false;
        }
        this._strict = filterProperties.getBoolean(STRICT_PROPERTY);
        return true;
    }

    @Override
    public void tearDown() {
        this._crypt.tearDown();
        super.tearDown();
    }

    protected void cryptException(@Nonnull Crypt.Result cryptResult) {
        CryptException exception = cryptResult.getException();
        if (exception.getCause() != null) {
            throw new RuntimeException(exception.getCause());
        }
        this.getThisLogger().warn((Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
    }

    @CheckReturnValue
    protected Crypt getCrypt() {
        return this._crypt;
    }

    @CheckReturnValue
    protected boolean isStrict() {
        return this._strict;
    }
}

