/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.CryptFilter;

public class DecryptFilter
extends CryptFilter {
    private String[] _decryptionKeyIdents;

    @Override
    public Serializable[] filter(Serializable message) {
        Serializable[] serializableArray;
        if (Crypt.isEncrypted((Serializable)message)) {
            Crypt.Result cryptResult = this.getCrypt().decrypt(message, this._decryptionKeyIdents);
            if (cryptResult.isSuccess()) {
                message = cryptResult.getSerializable();
            } else {
                this.cryptException(cryptResult);
                message = null;
            }
        } else if (this.isStrict()) {
            message = null;
        }
        if (message != null) {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = message;
        } else {
            serializableArray = NO_MESSAGES;
        }
        return serializableArray;
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        for (String decryptionKeyIdent : this._decryptionKeyIdents = filterProperties.getStrings("devrypt.key")) {
            this.getThisLogger().debug((Messages.Entry)ForwarderMessages.DECRYPTION_KEY, new Object[]{decryptionKeyIdent});
        }
        return true;
    }
}

