/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.CryptFilter;
import org.rvpf.forwarder.filter.SignFilter;

public class EncryptFilter
extends CryptFilter {
    private String[] _encryptionKeyIdents;
    private SignFilter _signFilter;

    @Override
    public Serializable[] filter(Serializable message) {
        Serializable[] serializableArray;
        if (this.isStrict() || !Crypt.isEncrypted((Serializable)message)) {
            Crypt.Result cryptResult = this.getCrypt().encrypt(message, this._encryptionKeyIdents);
            if (cryptResult.isSuccess()) {
                message = cryptResult.getSerializable();
            } else {
                this.cryptException(cryptResult);
                message = null;
            }
        }
        if (this._signFilter != null && message != null) {
            return this._signFilter.filter(message);
        }
        if (message != null) {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = message;
        } else {
            serializableArray = NO_MESSAGES;
        }
        return serializableArray;
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        for (String keyIdent : this._encryptionKeyIdents = filterProperties.getStrings("encrypt.key")) {
            this.getThisLogger().debug((Messages.Entry)ForwarderMessages.ENCRYPTION_KEY, new Object[]{keyIdent});
        }
        if (filterProperties.getBoolean("sign")) {
            this._signFilter = new SignFilter();
            if (!this._signFilter.setUp(forwarderModule, filterProperties)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void tearDown() {
        if (this._signFilter != null) {
            this._signFilter.tearDown();
        }
        super.tearDown();
    }
}

