/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.Points;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.document.loader.MetadataDocumentLoader;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.PointEntity;

public interface ForwarderFilter {
    @Nonnull
    @CheckReturnValue
    public Serializable[] filter(@Nonnull Serializable var1) throws InterruptedException, ServiceNotAvailableException;

    @CheckReturnValue
    public boolean needsMetadata();

    @CheckReturnValue
    public boolean onMetadataRefreshed();

    @CheckReturnValue
    public boolean setUp(@Nonnull ForwarderModule var1, @Nonnull KeyedGroups var2);

    public void tearDown();

    @NotThreadSafe
    public static abstract class Abstract
    implements ForwarderFilter {
        public static final String FILTER_UUID_PROPERTY = "filter.uuid";
        public static final String WARN_DROPPED_PROPERTY = "warn.dropped";
        protected static final Serializable[] NO_MESSAGES = new Serializable[0];
        private final Logger _logger = Logger.getInstance(this.getClass());
        private Metadata _metadata;
        private ForwarderModule _module;
        private Optional<UUID> _uuid = Optional.empty();
        private boolean _warnDropped;

        @Override
        public boolean needsMetadata() {
            return false;
        }

        @Override
        public boolean onMetadataRefreshed() {
            return !this.needsMetadata();
        }

        @Override
        public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
            this._module = forwarderModule;
            Optional uuidString = filterProperties.getString(FILTER_UUID_PROPERTY);
            if (uuidString.isPresent()) {
                if (!UUID.isUUID((String)((String)uuidString.get()))) {
                    this.getThisLogger().error((Messages.Entry)ForwarderMessages.BAD_FILTER_UUID, new Object[]{uuidString.get()});
                    return false;
                }
                this._uuid = UUID.fromString((String)((String)uuidString.get()));
                this.getThisLogger().debug((Messages.Entry)ForwarderMessages.FILTER_UUID, new Object[]{this._uuid});
            }
            this._warnDropped = filterProperties.getBoolean(WARN_DROPPED_PROPERTY);
            return true;
        }

        @Override
        public void tearDown() {
            this._module = null;
        }

        @Nonnull
        @CheckReturnValue
        protected final Metadata getMetadata() {
            return (Metadata)Require.notNull((Object)this._metadata);
        }

        @Nonnull
        @CheckReturnValue
        protected final ForwarderModule getModule() {
            return (ForwarderModule)Require.notNull((Object)this._module);
        }

        @Nonnull
        @CheckReturnValue
        protected final Logger getThisLogger() {
            return this._logger;
        }

        @Nonnull
        @CheckReturnValue
        protected Optional<UUID> getUUID() {
            return this._uuid;
        }

        @Nonnull
        @CheckReturnValue
        protected final Optional<PointValue> knownPointValue(@Nonnull Serializable message) {
            PointValue pointValue;
            if (message instanceof PointValue) {
                pointValue = (PointValue)message;
                if (pointValue.getPoint().orElse(null) instanceof PointEntity.Definition) {
                    pointValue = pointValue.reset();
                }
                if (!(pointValue = pointValue.restore((Points)this.getMetadata())).getPoint().isPresent()) {
                    this.logDropped(ForwarderMessages.DROPPED_UNKNOWN_POINT, pointValue);
                    pointValue = null;
                }
            } else {
                this.logDropped(ForwarderMessages.DROPPED_NOT_POINT_VALUE, message.getClass());
                pointValue = null;
            }
            return Optional.ofNullable(pointValue);
        }

        @CheckReturnValue
        protected final boolean loadMetadata(@Nonnull MetadataFilter metadataFilter) {
            Require.success((boolean)this.needsMetadata());
            Metadata metadata = MetadataDocumentLoader.fetchMetadata(metadataFilter, Optional.of(this.getModule().getConfig()), this._uuid, Optional.empty());
            if (metadata != null) {
                if (this.onNewMetadata(metadata)) {
                    metadata.setService(this.getModule().getService());
                } else {
                    metadata = null;
                }
            }
            this._metadata = metadata;
            return this._metadata != null;
        }

        protected void logDropped(@Nonnull Messages.Entry entry, Object ... params) {
            if (this._warnDropped) {
                this.getThisLogger().warn(entry, params);
            } else {
                this.getThisLogger().trace(entry, params);
            }
        }

        @CheckReturnValue
        protected boolean onNewMetadata(@Nonnull Metadata metadata) {
            return true;
        }
    }
}

