/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import org.rvpf.base.Point;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.PointValueFilters;
import org.rvpf.base.value.PointValue;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.ForwarderFilter;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.PointEntity;

public final class PointValueFilter
extends ForwarderFilter.Abstract {
    public static final String STAMP_REQUIRED_PROPERTY = "stamp.required";
    private boolean _stampRequired;
    private final PointValueFilters _valueFilters = new PointValueFilters();

    @Override
    public synchronized Serializable[] filter(Serializable message) {
        PointValue pointValue = this.knownPointValue(message).orElse(null);
        if (pointValue == null) {
            return NO_MESSAGES;
        }
        pointValue = pointValue.encoded();
        if (this._stampRequired && !pointValue.hasStamp()) {
            pointValue = pointValue.copy();
        }
        PointValue[] filteredValues = this._valueFilters.filter(pointValue);
        for (int i = 0; i < filteredValues.length; ++i) {
            PointValue filteredValue = filteredValues[i];
            String pointName = (String)filteredValue.getPointName().get();
            filteredValue = filteredValue.reset();
            filteredValue.setPointName(pointName);
            filteredValues[i] = filteredValue;
        }
        return filteredValues;
    }

    @Override
    public boolean needsMetadata() {
        return true;
    }

    @Override
    public synchronized boolean onMetadataRefreshed() {
        return this._loadMetadata();
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        this._stampRequired = filterProperties.getBoolean(STAMP_REQUIRED_PROPERTY);
        if (!this._loadMetadata()) {
            return false;
        }
        return super.setUp(forwarderModule, filterProperties);
    }

    @Override
    protected boolean onNewMetadata(Metadata metadata) {
        for (Point point : metadata.getPointsCollection()) {
            if (((PointEntity)point).setUp(metadata)) continue;
            return false;
        }
        this._valueFilters.clear();
        this._valueFilters.filterPoints(metadata.getPointsCollection());
        return super.onNewMetadata(metadata);
    }

    @CheckReturnValue
    private boolean _loadMetadata() {
        final class _MetadataFilter
        extends MetadataFilter {
            public _MetadataFilter() {
                super(true);
            }

            @Override
            public boolean areContentsNeeded() {
                return true;
            }
        }
        return this.loadMetadata(new _MetadataFilter());
    }
}

