/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.store.Store;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.RecalcTrigger;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.ForwarderFilter;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.StoreEntity;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;

public final class ProcessorFilter
extends ForwarderFilter.Abstract {
    public static final String CONFIRM_ALWAYS_KEYWORD = "always";
    public static final String CONFIRM_MARKED_KEYWORD = "marked";
    public static final String CONFIRM_NEVER_KEYWORD = "never";
    public static final String CONFIRM_PROPERTY = "confirm";
    public static final Messages.Entry CONFIRM_NEVER = ForwarderMessages.CONFIRM_NEVER;
    public static final Messages.Entry CONFIRM_MARKED = ForwarderMessages.CONFIRM_MARKED;
    public static final Messages.Entry CONFIRM_ALWAYS = ForwarderMessages.CONFIRM_ALWAYS;
    public static final Messages.Entry CONFIRM_REPLICATED = ForwarderMessages.CONFIRM_REPLICATED;
    public static final String CONFIRM_REPLICATED_KEYWORD = "replicated";
    public static final String CONFIRM_VALUE_PROPERTY = "confirm.value";
    public static final String PROCESSOR_PROPERTY = "processor";
    public static final String REPLICATES_PROPERTY = "replicates";
    public static final String RESYNCHRONIZES_PROPERTY = "resynchronizes";
    private Messages.Entry _confirm;
    private boolean _confirmValue;
    private String _processorName;
    private boolean _replicates;
    private boolean _resynchronizes;

    @Override
    public Serializable[] filter(Serializable message) throws InterruptedException, ServiceNotAvailableException {
        Serializable[] serializableArray;
        PointValue pointValue = this.knownPointValue(message).orElse(null);
        if (pointValue == null) {
            return NO_MESSAGES;
        }
        if (pointValue instanceof RecalcTrigger) {
            Serializable[] serializableArray2;
            Point point = (Point)pointValue.getPoint().get();
            if (point.getOrigin().isPresent()) {
                Serializable[] serializableArray3 = new Serializable[1];
                serializableArray2 = serializableArray3;
                serializableArray3[0] = pointValue;
            } else {
                serializableArray2 = NO_MESSAGES;
            }
            return serializableArray2;
        }
        Point point = (Point)pointValue.getPoint().get();
        if (point.getResults().isEmpty()) {
            return NO_MESSAGES;
        }
        Optional sync = point.getSync();
        boolean inSync = !sync.isPresent() || ((Sync)sync.get()).isInSync(pointValue.getStamp());
        Store store = point.getStore().orElse(null);
        boolean dropped = !inSync;
        boolean mayConfirm = false;
        boolean mustConfirm = false;
        boolean confirmed = false;
        boolean rejected = false;
        if (store != null && store.canConfirm() && (mayConfirm = store.getParams().getBoolean("Confirm", true))) {
            mayConfirm = point.getParams().getBoolean("Confirm", true);
        }
        if (mayConfirm) {
            if (this._confirm == CONFIRM_ALWAYS) {
                mustConfirm = true;
            } else if (this._confirm == CONFIRM_MARKED && !(mustConfirm = store.getParams().getBoolean("Confirm"))) {
                mustConfirm = point.getParams().getBoolean("Confirm");
            }
        }
        if (mustConfirm) {
            rejected = !pointValue.confirm(this._confirmValue);
            confirmed = true;
        }
        if (!rejected) {
            if (!confirmed && this._confirm == CONFIRM_REPLICATED && this._replicates && mayConfirm) {
                boolean bl = rejected = !pointValue.confirm(this._confirmValue);
            }
            if (!(rejected && this._replicates || !this._resynchronizes || inSync && !this._replicates)) {
                dropped = false;
            }
        }
        if (rejected) {
            this.logDropped(ForwarderMessages.NOTICE_REJECTED, pointValue);
        }
        if (dropped) {
            if (point.getParams().getBoolean("Resynchronized")) {
                this.getThisLogger().trace((Messages.Entry)ForwarderMessages.NOTICE_DROPPED, new Object[]{pointValue});
            } else {
                this.logDropped(ForwarderMessages.NOTICE_DROPPED, pointValue);
            }
        }
        if (rejected || dropped) {
            serializableArray = NO_MESSAGES;
        } else {
            Serializable[] serializableArray4 = new Serializable[1];
            serializableArray = serializableArray4;
            serializableArray4[0] = message;
        }
        return serializableArray;
    }

    @Override
    public boolean needsMetadata() {
        return true;
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        String confirm = (String)filterProperties.getString(CONFIRM_PROPERTY, Optional.of(CONFIRM_NEVER_KEYWORD)).get();
        if (confirm.equalsIgnoreCase(CONFIRM_NEVER_KEYWORD)) {
            this._confirm = CONFIRM_NEVER;
        } else if (confirm.equalsIgnoreCase(CONFIRM_REPLICATED_KEYWORD)) {
            this._confirm = CONFIRM_REPLICATED;
        } else if (confirm.equalsIgnoreCase(CONFIRM_MARKED_KEYWORD)) {
            this._confirm = CONFIRM_MARKED;
        } else if (confirm.equalsIgnoreCase(CONFIRM_ALWAYS_KEYWORD)) {
            this._confirm = CONFIRM_ALWAYS;
        } else {
            Messages.Entry entry = this._confirm = ValueConverter.convertToBoolean((String)ServiceMessages.PROPERTY_TYPE.toString(), (String)CONFIRM_PROPERTY, Optional.of(confirm), (boolean)false) ? CONFIRM_ALWAYS : CONFIRM_NEVER;
        }
        if (this._confirm != CONFIRM_NEVER) {
            this._confirmValue = filterProperties.getBoolean(CONFIRM_VALUE_PROPERTY);
        }
        this.getThisLogger().debug((Messages.Entry)ForwarderMessages.CONFIRM, new Object[]{this._confirm, ValueConverter.toInteger((boolean)this._confirmValue)});
        this._processorName = filterProperties.getString(PROCESSOR_PROPERTY).orElse(null);
        if (this._processorName == null) {
            this.getThisLogger().error((Messages.Entry)BaseMessages.MISSING_PROPERTY, new Object[]{PROCESSOR_PROPERTY});
            return false;
        }
        this.getThisLogger().debug((Messages.Entry)ServiceMessages.PROCESSOR_NAME, new Object[]{this._processorName});
        this._resynchronizes = filterProperties.getBoolean(RESYNCHRONIZES_PROPERTY);
        this.getThisLogger().debug((Messages.Entry)ForwarderMessages.RESYNCHRONIZES, new Object[]{this._resynchronizes});
        this._replicates = filterProperties.getBoolean(REPLICATES_PROPERTY);
        this.getThisLogger().debug((Messages.Entry)ForwarderMessages.REPLICATES, new Object[]{this._replicates});
        if (!this.loadMetadata(new _MetadataFilter())) {
            return false;
        }
        if (this._confirm != CONFIRM_NEVER) {
            Service service = this.getModule().getConfig().getService();
            for (StoreEntity storeEntity : this.getMetadata().getStoreEntities()) {
                service.monitorService(Optional.empty(), storeEntity.getUUID(), storeEntity.getName());
            }
        }
        return true;
    }

    @Override
    protected boolean onNewMetadata(Metadata metadata) {
        if (!metadata.getOriginEntity(Optional.of(this._processorName)).isPresent()) {
            this.getThisLogger().error((Messages.Entry)ServiceMessages.PROCESSOR_NOT_FOUND, new Object[]{this._processorName});
            return false;
        }
        Iterator<Point> i = metadata.getPointsCollection().iterator();
        while (i.hasNext()) {
            PointEntity pointEntity = (PointEntity)i.next();
            if (pointEntity.getOriginEntity().isPresent() || !pointEntity.getResults().isEmpty()) {
                if (pointEntity.setUp(metadata)) continue;
                return false;
            }
            i.remove();
        }
        metadata.cleanUp();
        return super.onNewMetadata(metadata);
    }

    @Nonnull
    @CheckReturnValue
    Messages.Entry _getConfirm() {
        return (Messages.Entry)Require.notNull((Object)this._confirm);
    }

    @Nonnull
    @CheckReturnValue
    String _getProcessorName() {
        return (String)Require.notNull((Object)this._processorName);
    }

    private final class _MetadataFilter
    extends MetadataFilter {
        private OriginEntity _processor;

        _MetadataFilter() {
            super(false);
        }

        @Override
        public boolean areOriginsFiltered() {
            return true;
        }

        @Override
        public boolean areOriginsNeeded() {
            return true;
        }

        @Override
        public boolean areOriginsRequired() {
            return false;
        }

        @Override
        public boolean arePointInputsNeeded() {
            return true;
        }

        @Override
        public boolean arePointInputsNeeded(PointEntity pointEntity) throws ValidationException {
            Optional<OriginEntity> originEntity = pointEntity.getOriginEntity();
            boolean needed = originEntity.isPresent() ? originEntity.get() == this._processor : false;
            return needed;
        }

        @Override
        public boolean areStoresNeeded() {
            return ProcessorFilter.this._getConfirm() != CONFIRM_NEVER;
        }

        @Override
        public boolean isOriginNeeded(OriginEntity originEntity) {
            boolean needed;
            boolean bl = needed = this._processor == null && ProcessorFilter.this._getProcessorName().equalsIgnoreCase(originEntity.getName().orElse(null));
            if (needed) {
                this._processor = originEntity;
            }
            return needed;
        }

        @Override
        public void reset() {
            this._processor = null;
            super.reset();
        }

        @Override
        protected void includeOriginsXML(XMLElement root) {
            root.addChild("origins").setAttribute("origins", ProcessorFilter.this._getProcessorName());
        }
    }
}

