/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.CryptFilter;

public class SignFilter
extends CryptFilter {
    private String[] _signingKeyIdents;

    @Override
    public Serializable[] filter(Serializable message) {
        Serializable[] serializableArray;
        if (this.isStrict() || !Crypt.isSigned((Serializable)message)) {
            Crypt.Result cryptResult = this.getCrypt().sign(message, this._signingKeyIdents);
            if (cryptResult.isSuccess()) {
                message = cryptResult.getSerializable();
            } else {
                this.cryptException(cryptResult);
                message = null;
            }
        }
        if (message != null) {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = message;
        } else {
            serializableArray = NO_MESSAGES;
        }
        return serializableArray;
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        for (String signingKeyIdent : this._signingKeyIdents = filterProperties.getStrings("sign.key")) {
            this.getThisLogger().debug((Messages.Entry)ForwarderMessages.SIGNING_KEY, new Object[]{signingKeyIdent});
        }
        return true;
    }
}

