/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.ForwarderFilter;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.StoreEntity;
import org.rvpf.service.ServiceMessages;

public final class StoreFilter
extends ForwarderFilter.Abstract {
    public static final String STORE_PROPERTY = "store";
    private String _storeName;

    @Override
    public Serializable[] filter(Serializable message) {
        Serializable[] serializableArray;
        if ((message = (Serializable)this.knownPointValue(message).orElse(null)) != null) {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = message;
        } else {
            serializableArray = NO_MESSAGES;
        }
        return serializableArray;
    }

    @Override
    public boolean needsMetadata() {
        return true;
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        this._storeName = filterProperties.getString(STORE_PROPERTY).orElse(null);
        if (this._storeName == null) {
            this.getThisLogger().error((Messages.Entry)BaseMessages.MISSING_PROPERTY, new Object[]{STORE_PROPERTY});
            return false;
        }
        this.getThisLogger().debug((Messages.Entry)ServiceMessages.STORE_NAME, new Object[]{this._storeName});
        return this.loadMetadata(new _MetadataFilter());
    }

    @Override
    protected boolean onNewMetadata(Metadata metadata) {
        if (!metadata.getStoreEntity(Optional.of(this._storeName)).isPresent()) {
            this.getThisLogger().error((Messages.Entry)ServiceMessages.STORE_NOT_FOUND, new Object[]{this._storeName});
            return false;
        }
        return super.onNewMetadata(metadata);
    }

    String _getStoreName() {
        return (String)Require.notNull((Object)this._storeName);
    }

    private final class _MetadataFilter
    extends MetadataFilter {
        private StoreEntity _storeEntity;

        _MetadataFilter() {
            super(false);
        }

        @Override
        public boolean isPointNeeded(PointEntity pointEntity) {
            return pointEntity.getStoreEntity().orElse(null) == this._storeEntity;
        }

        @Override
        public boolean isStoreNeeded(StoreEntity storeEntity) {
            boolean needed;
            boolean bl = needed = this._storeEntity == null && StoreFilter.this._getStoreName().equalsIgnoreCase(storeEntity.getName().orElse(null));
            if (needed) {
                this._storeEntity = storeEntity;
            }
            return needed;
        }

        @Override
        public void reset() {
            this._storeEntity = null;
            super.reset();
        }

        @Override
        protected void includeStoresXML(XMLElement root) {
            root.addChild("stores").setAttribute(StoreFilter.STORE_PROPERTY, StoreFilter.this._getStoreName());
        }
    }
}

