/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.filter;

import java.io.Serializable;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.forwarder.filter.CryptFilter;
import org.rvpf.forwarder.filter.DecryptFilter;

public class VerifyFilter
extends CryptFilter {
    private DecryptFilter _decryptFilter;
    private String[] _verificationKeyIdents;

    @Override
    public Serializable[] filter(Serializable message) {
        Serializable[] serializableArray;
        if (Crypt.isSigned((Serializable)message)) {
            boolean verified;
            Crypt.Result verifyResult = this.getCrypt().verify(message, this._verificationKeyIdents);
            if (verifyResult.isSuccess()) {
                verified = verifyResult.isVerified();
            } else {
                this.cryptException(verifyResult);
                verified = false;
            }
            if (!verified) {
                this.getThisLogger().warn((Messages.Entry)ForwarderMessages.VERIFICATION_FAILED, new Object[0]);
            }
            message = verified ? verifyResult.getSerializable() : null;
        } else if (this.isStrict()) {
            message = null;
        }
        if (this._decryptFilter != null && message != null) {
            return this._decryptFilter.filter(message);
        }
        if (message != null) {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = message;
        } else {
            serializableArray = NO_MESSAGES;
        }
        return serializableArray;
    }

    @Override
    public boolean setUp(ForwarderModule forwarderModule, KeyedGroups filterProperties) {
        if (!super.setUp(forwarderModule, filterProperties)) {
            return false;
        }
        for (String verificationKeyIdent : this._verificationKeyIdents = filterProperties.getStrings("verify.key")) {
            this.getThisLogger().debug((Messages.Entry)ForwarderMessages.VERIFICATION_KEY, new Object[]{verificationKeyIdent});
        }
        if (filterProperties.getBoolean("decrypt")) {
            this._decryptFilter = new DecryptFilter();
            if (!this._decryptFilter.setUp(forwarderModule, filterProperties)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void tearDown() {
        if (this._decryptFilter != null) {
            this._decryptFilter.tearDown();
        }
        super.tearDown();
    }
}

