/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.input.InputModule;
import org.rvpf.service.Alerter;

public final class FromAlerterModule
extends InputModule {
    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        this.setInput(new _AlertReceiver());
        return super.setUp(moduleProperties);
    }

    private final class _AlertReceiver
    extends InputModule.AbstractInput
    implements Alerter.Listener {
        private final BlockingQueue<Alert> _alerts = new LinkedBlockingQueue<Alert>();
        private final AtomicBoolean _closed = new AtomicBoolean();

        _AlertReceiver() {
        }

        @Override
        public void close() {
            if (this._closed.compareAndSet(false, true)) {
                Require.ignored((boolean)FromAlerterModule.this.getConfig().getService().removeAlertListener(this));
                this._alerts.clear();
            }
        }

        @Override
        public String getDisplayName() {
            return "From Alerter";
        }

        @Override
        public String getSourceName() {
            return "Alerter";
        }

        @Override
        public Optional<Serializable[]> input(BatchControl batchControl) throws InterruptedException {
            int limit = batchControl.getLimit();
            Optional<ElapsedTime> wait = batchControl.getWait();
            LinkedList<Alert> alertList = new LinkedList<Alert>();
            int count = 0;
            long timeout = -1L;
            while (true) {
                Alert alert;
                if (timeout < 0L) {
                    alert = this._alerts.take();
                } else {
                    alert = this._alerts.poll(timeout, TimeUnit.MILLISECONDS);
                    if (alert == null) break;
                }
                alertList.add(alert);
                if (!wait.isPresent() || ++count >= limit) break;
                timeout = wait.get().toMillis();
            }
            if (FromAlerterModule.this.getTraces().isEnabled()) {
                for (Alert alert : alertList) {
                    FromAlerterModule.this.getTraces().add((Object)alert);
                }
            }
            return Optional.of(alertList.toArray(new Alert[alertList.size()]));
        }

        @Override
        public boolean isClosed() {
            return this._closed.get();
        }

        @Override
        public boolean isReliable() {
            return true;
        }

        @Override
        public boolean onAlert(Optional<Alert> alert) {
            return this._alerts.add(alert.get());
        }

        @Override
        public boolean open() {
            this._closed.set(false);
            if (!FromAlerterModule.this.getConfig().getService().addAlertListener(this)) {
                FromAlerterModule.this.getThisLogger().debug((Messages.Entry)ForwarderMessages.ADD_ALERT_LISTENER_FAILED, new Object[0]);
                return false;
            }
            return true;
        }
    }
}

